/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.tree;

import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.Tuple2;
import org.javimmutable.collections.cursors.StandardCursor;
import org.javimmutable.collections.iterators.EmptyIterator;
import org.javimmutable.collections.tree.LeafNode;
import org.javimmutable.collections.tree.Node;
import org.javimmutable.collections.tree.UpdateResult;

@Immutable
public class EmptyNode<K, V>
implements Node<K, V> {
    static final EmptyNode INSTANCE = new EmptyNode();

    public static <K, V> Node<K, V> of() {
        return INSTANCE;
    }

    @Override
    @Nullable
    public K baseKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int childCount() {
        return 0;
    }

    @Override
    public int valueCount() {
        return 0;
    }

    @Override
    public V getValueOr(@Nonnull Comparator<K> comparator, @Nonnull K key, V defaultValue) {
        return defaultValue;
    }

    @Override
    @Nonnull
    public Holder<V> find(@Nonnull Comparator<K> comparator, @Nonnull K key) {
        return Holders.of();
    }

    @Override
    @Nonnull
    public Holder<JImmutableMap.Entry<K, V>> findEntry(@Nonnull Comparator<K> comparator, @Nonnull K key) {
        return Holders.of();
    }

    @Override
    @Nonnull
    public UpdateResult<K, V> assign(@Nonnull Comparator<K> comparator, @Nonnull K key, V value) {
        return UpdateResult.createInPlace(new LeafNode<K, V>(key, value), 1);
    }

    @Override
    @Nonnull
    public UpdateResult<K, V> update(@Nonnull Comparator<K> comparator, @Nonnull K key, @Nonnull Func1<Holder<V>, V> generator) {
        return UpdateResult.createInPlace(new LeafNode<K, V>(key, generator.apply(Holders.of())), 1);
    }

    @Override
    @Nonnull
    public Node<K, V> delete(@Nonnull Comparator<K> comparator, @Nonnull K key) {
        return this;
    }

    @Override
    @Nonnull
    public Node<K, V> mergeChildren(@Nonnull Node<K, V> sibling) {
        return sibling;
    }

    @Override
    @Nonnull
    public Tuple2<Node<K, V>, Node<K, V>> distributeChildren(@Nonnull Node<K, V> sibling) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Node<K, V> compress() {
        return this;
    }

    @Override
    public int depth() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    @Nonnull
    public Cursor<JImmutableMap.Entry<K, V>> cursor() {
        return StandardCursor.of();
    }

    @Override
    @Nonnull
    public SplitableIterator<JImmutableMap.Entry<K, V>> iterator() {
        return EmptyIterator.of();
    }

    @Override
    public void checkInvariants(@Nonnull Comparator<K> comparator) {
    }
}

