/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.setmap;

import java.io.Serializable;
import java.util.Comparator;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.JImmutableSet;
import org.javimmutable.collections.JImmutableSetMap;
import org.javimmutable.collections.hash.JImmutableHashSet;
import org.javimmutable.collections.serialization.JImmutableTreeSetMapProxy;
import org.javimmutable.collections.setmap.AbstractJImmutableSetMap;
import org.javimmutable.collections.tree.JImmutableTreeMap;

@Immutable
public class JImmutableTreeSetMap<K, V>
extends AbstractJImmutableSetMap<K, V>
implements Serializable {
    private static final JImmutableTreeSetMap EMPTY = new JImmutableTreeSetMap(JImmutableTreeMap.of(), JImmutableHashSet.of());
    private static final long serialVersionUID = -121805L;
    private final Comparator<K> comparator;

    private JImmutableTreeSetMap(JImmutableTreeMap<K, JImmutableSet<V>> contents, JImmutableSet<V> emptySet) {
        this(contents, contents.getComparator(), emptySet);
    }

    private JImmutableTreeSetMap(JImmutableMap<K, JImmutableSet<V>> contents, Comparator<K> comparator, JImmutableSet<V> emptySet) {
        super(contents, emptySet);
        this.comparator = comparator;
    }

    public static <K extends Comparable<K>, V> JImmutableTreeSetMap<K, V> of() {
        return EMPTY;
    }

    public static <K, V> JImmutableTreeSetMap<K, V> of(Comparator<K> comparator) {
        return new JImmutableTreeSetMap(JImmutableTreeMap.of(comparator), JImmutableHashSet.of());
    }

    public Comparator<K> getComparator() {
        return this.comparator;
    }

    @Override
    public void checkInvariants() {
        this.checkSetMapInvariants();
    }

    @Override
    protected JImmutableSetMap<K, V> create(JImmutableMap<K, JImmutableSet<V>> map) {
        return new JImmutableTreeSetMap<K, V>(map, this.comparator, this.emptySet);
    }

    JImmutableMap<K, JImmutableSet<V>> getMap() {
        return this.contents;
    }

    private Object writeReplace() {
        return new JImmutableTreeSetMapProxy(this);
    }
}

