/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.serialization;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.JImmutableMultiset;

abstract class AbstractJImmutableMultisetProxy
implements Externalizable {
    private static final int MULTISET_VERSION = 1001;
    private static final long serialVersionUID = -121805L;
    protected JImmutableMultiset set;

    protected AbstractJImmutableMultisetProxy(JImmutableMultiset set) {
        this.set = set;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1001);
        this.writeSet(out);
        out.writeInt(this.set.size());
        for (JImmutableMap.Entry entry : this.set.entries()) {
            out.writeObject(entry.getKey());
            out.writeInt((Integer)entry.getValue());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version != 1001) {
            throw new IOException("unexpected version number: expected 1001 found " + version);
        }
        this.set = this.readSet(in);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = in.readObject();
            int count = in.readInt();
            this.set = this.set.insert(key, count);
        }
    }

    protected Object readResolve() {
        return this.set;
    }

    protected JImmutableMultiset readSet(ObjectInput in) throws IOException, ClassNotFoundException {
        return this.set;
    }

    protected void writeSet(ObjectOutput out) throws IOException {
    }
}

