/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.sequence;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.InsertableSequence;
import org.javimmutable.collections.sequence.EmptySequenceNode;

@Immutable
public class FilledSequenceNode<T>
implements InsertableSequence<T> {
    private final InsertableSequence<T> next;
    private final T value;

    private FilledSequenceNode(@Nonnull InsertableSequence<T> next, @Nullable T value) {
        this.next = next;
        this.value = value;
    }

    public static <T> InsertableSequence<T> of(@Nullable T value) {
        return new FilledSequenceNode(EmptySequenceNode.of(), value);
    }

    @Override
    @Nonnull
    public InsertableSequence<T> insert(T value) {
        return new FilledSequenceNode<T>(this, value);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public T getHead() {
        return this.value;
    }

    @Override
    @Nonnull
    public InsertableSequence<T> getTail() {
        return this.next;
    }
}

