/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.listmap;

import java.io.Serializable;
import java.util.Comparator;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.JImmutableList;
import org.javimmutable.collections.JImmutableListMap;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.list.JImmutableArrayList;
import org.javimmutable.collections.listmap.AbstractJImmutableListMap;
import org.javimmutable.collections.serialization.JImmutableTreeListMapProxy;
import org.javimmutable.collections.tree.JImmutableTreeMap;

@Immutable
public class JImmutableTreeListMap<K, V>
extends AbstractJImmutableListMap<K, V>
implements Serializable {
    private static final JImmutableTreeListMap EMPTY = new JImmutableTreeListMap(JImmutableTreeMap.of(), JImmutableArrayList.of());
    private static final long serialVersionUID = -121805L;
    private final Comparator<K> comparator;

    private JImmutableTreeListMap(JImmutableTreeMap<K, JImmutableList<V>> contents, JImmutableList<V> emptyList) {
        this(contents, contents.getComparator(), emptyList);
    }

    private JImmutableTreeListMap(JImmutableMap<K, JImmutableList<V>> contents, Comparator<K> comparator, JImmutableList<V> emptyList) {
        super(contents, emptyList);
        this.comparator = comparator;
    }

    public static <K extends Comparable<K>, V> JImmutableTreeListMap<K, V> of() {
        return EMPTY;
    }

    public static <K, V> JImmutableTreeListMap<K, V> of(Comparator<K> comparator) {
        return new JImmutableTreeListMap(JImmutableTreeMap.of(comparator), JImmutableArrayList.of());
    }

    public Comparator<K> getComparator() {
        return this.comparator;
    }

    @Override
    public void checkInvariants() {
        this.checkListMapInvariants();
    }

    @Override
    protected JImmutableListMap<K, V> create(JImmutableMap<K, JImmutableList<V>> map) {
        return new JImmutableTreeListMap<K, V>(map, this.comparator, this.emptyList);
    }

    JImmutableMap<K, JImmutableList<V>> getMap() {
        return this.contents;
    }

    private Object writeReplace() {
        return new JImmutableTreeListMapProxy(this);
    }
}

