/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.listmap;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.IterableStreamable;
import org.javimmutable.collections.JImmutableList;
import org.javimmutable.collections.JImmutableListMap;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.common.Conditions;
import org.javimmutable.collections.iterators.EntryIterableStreamable;

@Immutable
public abstract class AbstractJImmutableListMap<K, V>
implements JImmutableListMap<K, V> {
    protected final JImmutableList<V> emptyList;
    protected final JImmutableMap<K, JImmutableList<V>> contents;

    protected AbstractJImmutableListMap(JImmutableMap<K, JImmutableList<V>> contents, JImmutableList<V> emptyList) {
        this.emptyList = emptyList;
        this.contents = contents;
    }

    @Override
    @Nonnull
    public JImmutableList<V> getList(@Nonnull K key) {
        Conditions.stopNull(key);
        Holder<JImmutableList<V>> current = this.contents.find(key);
        return current.isFilled() ? current.getValue() : this.emptyList;
    }

    @Override
    @Nonnull
    public JImmutableListMap<K, V> assign(@Nonnull K key, @Nonnull JImmutableList<V> value) {
        Conditions.stopNull(key, value);
        return this.create(this.contents.assign(key, this.copyList(value)));
    }

    @Override
    @Nonnull
    public JImmutableListMap<K, V> insert(@Nonnull K key, @Nullable V value) {
        return this.create(this.contents.update(key, h -> h.getValueOr(this.emptyList).insertLast(value)));
    }

    @Override
    @Nonnull
    public JImmutableListMap<K, V> getInsertableSelf() {
        return this;
    }

    @Override
    @Nonnull
    public JImmutableListMap<K, V> delete(@Nonnull K key) {
        return this.create(this.contents.delete(key));
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    @Override
    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    @Override
    @Nonnull
    public Cursor<K> keysCursor() {
        return this.contents.keysCursor();
    }

    @Override
    @Nonnull
    public Cursor<V> valuesCursor(@Nonnull K key) {
        return this.getList(key).cursor();
    }

    @Override
    @Nonnull
    public IterableStreamable<K> keys() {
        return this.contents.keys();
    }

    @Override
    @Nonnull
    public IterableStreamable<V> values(@Nonnull K key) {
        return this.getList(key);
    }

    @Override
    @Nonnull
    public IterableStreamable<JImmutableMap.Entry<K, V>> entries() {
        return new EntryIterableStreamable(this);
    }

    @Override
    @Nonnull
    public Cursor<JImmutableMap.Entry<K, JImmutableList<V>>> cursor() {
        return this.contents.cursor();
    }

    @Override
    @Nonnull
    public JImmutableListMap<K, V> insert(@Nonnull JImmutableMap.Entry<K, V> e) {
        return this.insert(e.getKey(), e.getValue());
    }

    @Override
    @Nonnull
    public SplitableIterator<JImmutableMap.Entry<K, JImmutableList<V>>> iterator() {
        return this.contents.iterator();
    }

    @Override
    public int getSpliteratorCharacteristics() {
        return 1040;
    }

    @Override
    @Nullable
    public JImmutableList<V> get(K key) {
        return (JImmutableList)this.contents.get(key);
    }

    @Override
    public JImmutableList<V> getValueOr(K key, JImmutableList<V> defaultValue) {
        return this.contents.getValueOr(key, defaultValue);
    }

    @Override
    @Nonnull
    public Holder<JImmutableList<V>> find(K key) {
        return this.contents.find(key);
    }

    @Override
    @Nonnull
    public JImmutableListMap<K, V> deleteAll() {
        return this.create(this.contents.deleteAll());
    }

    public int hashCode() {
        return this.contents.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof AbstractJImmutableListMap && this.contents.equals(((AbstractJImmutableListMap)o).contents);
    }

    public String toString() {
        return this.contents.toString();
    }

    protected void checkListMapInvariants() {
        this.contents.checkInvariants();
        for (JImmutableMap.Entry entry : this.contents) {
            ((JImmutableList)entry.getValue()).checkInvariants();
        }
    }

    protected abstract JImmutableListMap<K, V> create(JImmutableMap<K, JImmutableList<V>> var1);

    protected JImmutableList<V> copyList(JImmutableList<V> original) {
        return original;
    }
}

