/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.list;

import java.util.Iterator;
import javax.annotation.Nonnull;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.SplitableIterable;
import org.javimmutable.collections.indexed.IndexedArray;
import org.javimmutable.collections.iterators.IndexedIterator;
import org.javimmutable.collections.list.BranchNode;
import org.javimmutable.collections.list.EmptyNode;
import org.javimmutable.collections.list.LeafNode;
import org.javimmutable.collections.list.ListHelper;
import org.javimmutable.collections.list.Node;

class TreeBuilder<T> {
    private final LeafBuilder<T> leafBuilder;

    TreeBuilder(boolean forwardOrder) {
        this.leafBuilder = new LeafBuilder(forwardOrder);
    }

    synchronized void add(T value) {
        ((LeafBuilder)this.leafBuilder).add(value);
    }

    synchronized int size() {
        return ((LeafBuilder)this.leafBuilder).size;
    }

    @Nonnull
    synchronized Node<T> build() {
        return ((LeafBuilder)this.leafBuilder).build();
    }

    @Nonnull
    static <T> Node<T> createFromIterator(int maxSize, boolean forwardOrder, @Nonnull Iterator<? extends T> values) {
        LeafBuilder builder = new LeafBuilder(forwardOrder);
        while (values.hasNext() && builder.size < maxSize) {
            builder.add(values.next());
        }
        return builder.build();
    }

    @Nonnull
    static <T> Node<T> expandLeafNode(int maxSize, boolean forwardOrder, @Nonnull LeafNode<T> nodeToFill, @Nonnull Iterator<? extends T> values) {
        assert (maxSize >= nodeToFill.size());
        LeafBuilder builder = new LeafBuilder(forwardOrder);
        Indexed<T> nodeValues = nodeToFill.values();
        SplitableIterable<T> prefill = forwardOrder ? IndexedIterator.fwd(nodeValues) : IndexedIterator.rev(nodeValues);
        for (Object t : prefill) {
            builder.add(t);
        }
        while (values.hasNext() && builder.size < maxSize) {
            builder.add(values.next());
        }
        return builder.build();
    }

    @Nonnull
    static <T> BranchNode<T> expandBranchNode(int maxSize, boolean forwardOrder, @Nonnull BranchNode<T> nodeToFill, @Nonnull Iterator<? extends T> values) {
        assert ((forwardOrder ? nodeToFill.suffix() : nodeToFill.prefix()).isEmpty());
        LeafBuilder builder = new LeafBuilder(forwardOrder, nodeToFill.filledNodes());
        assert (maxSize >= builder.size);
        while (values.hasNext() && builder.size < maxSize) {
            builder.add(values.next());
        }
        return (BranchNode)builder.build();
    }

    private static class BranchBuilder<T> {
        private final int depth;
        private final boolean forwardOrder;
        private final Node<T>[] nodes;
        private BranchBuilder<T> next;
        private int offset;
        private int remaining;
        private int size;

        private BranchBuilder(int depth, boolean forwardOrder) {
            this.depth = depth;
            this.forwardOrder = forwardOrder;
            this.nodes = ListHelper.allocateNodes(32);
            this.next = null;
            this.offset = forwardOrder ? 0 : 32;
            this.remaining = 32;
            this.size = 0;
        }

        private BranchBuilder(int depth, boolean forwardOrder, @Nonnull Indexed<Node<T>> startNodes) {
            this(depth, forwardOrder);
            assert (startNodes.size() > 0);
            if (startNodes.get(0).getDepth() == depth) {
                int nodeCount = startNodes.size();
                if (forwardOrder) {
                    for (int i = 0; i < nodeCount; ++i) {
                        Node<T> node = startNodes.get(i);
                        this.size += node.size();
                        this.nodes[this.offset++] = node;
                    }
                } else {
                    for (int i = nodeCount - 1; i >= 0; --i) {
                        Node<T> node = startNodes.get(i);
                        this.size += node.size();
                        this.nodes[--this.offset] = node;
                    }
                }
                this.remaining -= startNodes.size();
            } else {
                this.next = new BranchBuilder<T>(depth + 1, forwardOrder, startNodes);
            }
        }

        private void add(@Nonnull Node<T> node) {
            assert (node.isFull());
            assert (node.getDepth() == this.depth);
            if (this.forwardOrder) {
                this.nodes[this.offset++] = node;
            } else {
                this.nodes[--this.offset] = node;
            }
            this.size += node.size();
            if (this.remaining == 1) {
                if (this.next == null) {
                    this.next = new BranchBuilder<T>(this.depth + 1, this.forwardOrder);
                }
                super.add(this.createNodeForNext(EmptyNode.of()));
                this.offset = this.forwardOrder ? 0 : 32;
                this.remaining = 32;
                this.size = 0;
            } else {
                --this.remaining;
            }
        }

        private Node<T> build(@Nonnull Node<T> extra) {
            Node<T> node;
            if (this.remaining == 32) {
                node = extra;
            } else {
                if (this.remaining == 31 && this.next == null && extra.isEmpty()) {
                    int nodeOffset = this.forwardOrder ? this.offset - 1 : this.offset;
                    return this.nodes[nodeOffset];
                }
                node = this.createNodeForNext(extra);
            }
            if (this.next != null) {
                node = super.build(node);
            }
            return node;
        }

        @Nonnull
        private Node<T> createNodeForNext(@Nonnull Node<T> extra) {
            int nodeSize = this.size + extra.size();
            assert (nodeSize <= ListHelper.sizeForDepth(this.depth + 1));
            if (this.forwardOrder) {
                return BranchNode.forNodeBuilder(this.depth + 1, nodeSize, EmptyNode.of(), IndexedArray.retained(this.nodes), 0, this.offset, extra);
            }
            return BranchNode.forNodeBuilder(this.depth + 1, nodeSize, extra, IndexedArray.retained(this.nodes), this.offset, 32, EmptyNode.of());
        }
    }

    private static class LeafBuilder<T> {
        private final boolean forwardOrder;
        private final T[] values;
        private BranchBuilder<T> next;
        private int offset;
        private int remaining;
        private int size;

        private LeafBuilder(boolean forwardOrder) {
            this.forwardOrder = forwardOrder;
            this.values = ListHelper.allocateValues(32);
            this.offset = forwardOrder ? 0 : 32;
            this.remaining = 32;
        }

        private LeafBuilder(boolean forwardOrder, @Nonnull Indexed<Node<T>> startNodes) {
            this(forwardOrder);
            this.next = new BranchBuilder(1, forwardOrder, startNodes);
            for (Node node : IndexedIterator.fwd(startNodes)) {
                this.size += node.size();
            }
        }

        private void add(T value) {
            assert (this.remaining >= 1);
            if (this.forwardOrder) {
                this.values[this.offset++] = value;
            } else {
                this.values[--this.offset] = value;
            }
            if (this.remaining == 1) {
                if (this.next == null) {
                    this.next = new BranchBuilder(1, this.forwardOrder);
                }
                ((BranchBuilder)this.next).add(this.createNodeForNext());
                this.offset = this.forwardOrder ? 0 : 32;
                this.remaining = 32;
            } else {
                --this.remaining;
            }
            ++this.size;
        }

        @Nonnull
        private Node<T> createNodeForNext() {
            if (this.forwardOrder) {
                return LeafNode.fromList(IndexedArray.retained(this.values), 0, this.offset);
            }
            return LeafNode.fromList(IndexedArray.retained(this.values), this.offset, 32);
        }

        @Nonnull
        private Node<T> build() {
            Node myNode = this.remaining == 32 ? EmptyNode.of() : this.createNodeForNext();
            return this.next == null ? myNode : ((BranchBuilder)this.next).build(myNode);
        }
    }
}

