/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.list;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.javimmutable.collections.Insertable;
import org.javimmutable.collections.JImmutableList;
import org.javimmutable.collections.btree_list.JImmutableBtreeList;

public final class ListTimingComparison {
    public static void main(String[] argv) throws Exception {
        if (argv.length != 2) {
            System.err.println("usage: TimingComparison seed loops");
            System.exit(1);
        }
        long seed = Long.parseLong(argv[0]);
        int loops = Integer.parseInt(argv[1]);
        int maxCommand = 6;
        ListTimingComparison.runTests(seed, loops, 32, 6);
        System.gc();
        Thread.sleep(500L);
        ListTimingComparison.runTests(seed, loops, 1024, 6);
        System.gc();
        Thread.sleep(500L);
        ListTimingComparison.runTests(seed, loops, 10000, 6);
    }

    private static void runTests(long seed, int loops, int maxSize, int maxCommand) {
        System.out.printf("STARTING TEST WITH seed %d loops %d maxSize %d maxCommand %d%n", seed, loops, maxSize, maxCommand);
        for (int outerloop = 0; outerloop < 10; ++outerloop) {
            Random random = new Random(seed);
            int adds = 0;
            int sets = 0;
            int removes = 0;
            int gets = 0;
            long startMap = System.currentTimeMillis();
            ArrayList<Integer> expected = new ArrayList<Integer>();
            for (int i = 1; i <= loops; ++i) {
                int index;
                int value;
                int command = random.nextInt(maxCommand);
                if (expected.isEmpty()) {
                    value = random.nextInt();
                    expected.add(value);
                    ++adds;
                    continue;
                }
                if (command <= 1) {
                    value = random.nextInt();
                    if (expected.size() < maxSize) {
                        expected.add(value);
                        ++adds;
                        continue;
                    }
                    int index2 = random.nextInt(expected.size());
                    expected.set(index2, value);
                    ++sets;
                    continue;
                }
                if (command == 2) {
                    expected.remove(expected.size() - 1);
                    ++removes;
                    continue;
                }
                if (command == 3) {
                    index = random.nextInt(expected.size());
                    int value2 = random.nextInt();
                    expected.set(index, value2);
                    ++sets;
                    continue;
                }
                index = random.nextInt(expected.size());
                expected.get(index);
                ++gets;
            }
            long endMap = System.currentTimeMillis();
            System.out.printf("jlist adds %d sets %s removes %d gets %d size %d elapsed %d%n", adds, sets, removes, gets, expected.size(), endMap - startMap);
            random = new Random(seed);
            adds = 0;
            sets = 0;
            removes = 0;
            gets = 0;
            long startPer = System.currentTimeMillis();
            Insertable<Integer, JImmutableList<Integer>> list = JImmutableBtreeList.of();
            for (int i = 1; i <= loops; ++i) {
                int index;
                int value;
                int command = random.nextInt(maxCommand);
                if (list.isEmpty()) {
                    value = random.nextInt();
                    list = list.insert((Object)value);
                    ++adds;
                    continue;
                }
                if (command <= 1) {
                    value = random.nextInt();
                    if (list.size() < maxSize) {
                        list = list.insert((Object)value);
                        ++adds;
                        continue;
                    }
                    int index3 = random.nextInt(list.size());
                    list = list.assign(index3, value);
                    ++sets;
                    continue;
                }
                if (command == 2) {
                    list = list.deleteLast();
                    ++removes;
                    continue;
                }
                if (command == 3) {
                    index = random.nextInt(list.size());
                    int value3 = random.nextInt();
                    list = list.assign(index, value3);
                    ++sets;
                    continue;
                }
                index = random.nextInt(list.size());
                list.get(index);
                ++gets;
            }
            long endPer = System.currentTimeMillis();
            System.out.printf("ilist adds %d sets %d removes %d gets %d size %d elapsed %d%n", adds, sets, removes, gets, list.size(), endPer - startPer);
            Iterator expectedIterator = expected.iterator();
            Iterator listIterator = list.iterator();
            while (true) {
                ListTimingComparison.assertEquals(expectedIterator.hasNext(), listIterator.hasNext());
                if (!expectedIterator.hasNext()) break;
                ListTimingComparison.assertEquals((Integer)expectedIterator.next(), (Integer)listIterator.next());
            }
            System.out.println();
        }
    }

    private static void assertEquals(boolean a, boolean b) {
        if (a != b) {
            throw new RuntimeException();
        }
    }

    private static void assertEquals(Integer a, Integer b) {
        if (!a.equals(b)) {
            throw new RuntimeException();
        }
    }
}

