/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.list;

import javax.annotation.Nonnull;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.list.Node;

final class ListHelper {
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final Node[] EMPTY_NODES = new Node[0];

    ListHelper() {
    }

    static <T> Node<T>[] allocateNodes(int size) {
        return size == 0 ? EMPTY_NODES : new Node[size];
    }

    static <T> Node<T>[] allocateNodes(@Nonnull Indexed<Node<T>> source, int offset, int limit) {
        assert (source.size() >= limit - offset);
        int size = limit - offset;
        Node<T>[] nodes = ListHelper.allocateNodes(size);
        for (int i = 0; i < size; ++i) {
            nodes[i] = source.get(offset + i);
        }
        return nodes;
    }

    static <T> T[] allocateValues(int size) {
        return size == 0 ? EMPTY_VALUES : new Object[size];
    }

    static <T> Node<T>[] allocateSingleNode(Node<T> node) {
        Node<T>[] answer = ListHelper.allocateNodes(1);
        answer[0] = node;
        return answer;
    }

    static int sizeForDepth(int depth) {
        return 1 << 5 * depth;
    }

    static <T> boolean allNodesFull(int depth, @Nonnull Indexed<Node<T>> nodes, int offset, int limit) {
        for (int i = offset; i < limit; ++i) {
            Node<T> node = nodes.get(i);
            if (node.getDepth() != depth - 1) {
                return false;
            }
            if (node.isFull()) continue;
            return false;
        }
        return true;
    }
}

