/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.list;

import java.util.ArrayList;
import org.javimmutable.collections.JImmutableList;
import org.javimmutable.collections.list.JImmutableArrayList;

public class ListAppendTimingComparison {
    public static void main(String[] argv) {
        Mode mode = argv.length == 0 ? Mode.OLD_LAST : Mode.valueOf(argv[0].replace("-", "_").toUpperCase());
        long startMillis = System.currentTimeMillis();
        ListAppendTimingComparison.runTest(mode);
        long elapsedMillis = System.currentTimeMillis() - startMillis;
        System.out.printf("%s  %d%n", new Object[]{mode, elapsedMillis});
    }

    private static void runTest(Mode mode) {
        for (int loop = 1; loop <= 10000; ++loop) {
            JImmutableList<Object> list = JImmutableArrayList.of();
            ArrayList<Integer> extras = new ArrayList<Integer>();
            block7: for (int length = 1; length <= 250; ++length) {
                extras.add(length);
                switch (mode) {
                    case OLD_FIRST: {
                        list = list.insertAllFirstOldWay(extras.iterator());
                        continue block7;
                    }
                    case OLD_LAST: {
                        list = list.insertAllLastOldWay(extras.iterator());
                        continue block7;
                    }
                    case NEW_FIRST: {
                        list = list.insertAllFirst(extras);
                        continue block7;
                    }
                    case NEW_LAST: {
                        list = list.insertAllLast(extras);
                    }
                }
            }
        }
    }

    private static enum Mode {
        OLD_FIRST,
        OLD_LAST,
        NEW_FIRST,
        NEW_LAST;

    }
}

