/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.list;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.cursors.StandardCursor;
import org.javimmutable.collections.indexed.IndexedArray;
import org.javimmutable.collections.indexed.IndexedList;
import org.javimmutable.collections.iterators.IndexedIterator;
import org.javimmutable.collections.list.BranchNode;
import org.javimmutable.collections.list.EmptyNode;
import org.javimmutable.collections.list.ListHelper;
import org.javimmutable.collections.list.Node;
import org.javimmutable.collections.list.TreeBuilder;

@Immutable
class LeafNode<T>
implements Node<T> {
    @Nonnull
    private final T[] values;

    private LeafNode(@Nonnull T[] values) {
        assert (values.length > 0);
        assert (values.length <= 32);
        this.values = values;
    }

    LeafNode(T value) {
        this.values = ListHelper.allocateValues(1);
        this.values[0] = value;
    }

    static <T> LeafNode<T> fromList(List<T> values, int offset, int limit) {
        return LeafNode.fromList(IndexedList.retained(values), offset, limit);
    }

    static <T> LeafNode<T> fromList(Indexed<? extends T> values, int offset, int limit) {
        T[] array = ListHelper.allocateValues(limit - offset);
        for (int i = offset; i < limit; ++i) {
            array[i - offset] = values.get(i);
        }
        return new LeafNode<T[]>(array);
    }

    static <T> LeafNode<T> forTesting(T[] values) {
        return new LeafNode<Object[]>((Object[])values.clone());
    }

    @Override
    public boolean isEmpty() {
        return this.values.length == 0;
    }

    @Override
    public boolean isFull() {
        return this.values.length == 32;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public int getDepth() {
        return 1;
    }

    @Override
    public Node<T> deleteFirst() {
        if (this.values.length == 1) {
            return EmptyNode.of();
        }
        T[] newValues = ListHelper.allocateValues(this.values.length - 1);
        System.arraycopy(this.values, 1, newValues, 0, newValues.length);
        return new LeafNode<T[]>(newValues);
    }

    @Override
    public Node<T> deleteLast() {
        if (this.values.length == 1) {
            return EmptyNode.of();
        }
        T[] newValues = ListHelper.allocateValues(this.values.length - 1);
        System.arraycopy(this.values, 0, newValues, 0, newValues.length);
        return new LeafNode<T[]>(newValues);
    }

    @Override
    public Node<T> insertFirst(T value) {
        if (this.isFull()) {
            return new BranchNode<T>(value, this);
        }
        T[] newValues = ListHelper.allocateValues(this.values.length + 1);
        System.arraycopy(this.values, 0, newValues, 1, this.values.length);
        newValues[0] = value;
        return new LeafNode<T[]>(newValues);
    }

    @Override
    public Node<T> insertLast(T value) {
        if (this.isFull()) {
            return new BranchNode<T>(this, value);
        }
        T[] newValues = ListHelper.allocateValues(this.values.length + 1);
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newValues[this.values.length] = value;
        return new LeafNode<T[]>(newValues);
    }

    @Override
    public boolean containsIndex(int index) {
        return index >= 0 && index < this.values.length;
    }

    @Override
    public T get(int index) {
        return this.values[index];
    }

    @Override
    public Node<T> assign(int index, T value) {
        Object[] newValues = (Object[])this.values.clone();
        newValues[index] = value;
        return new LeafNode<Object[]>(newValues);
    }

    @Override
    public Node<T> insertAll(int maxSize, boolean forwardOrder, @Nonnull Iterator<? extends T> values) {
        return TreeBuilder.expandLeafNode(maxSize, forwardOrder, this, values);
    }

    @Override
    @Nonnull
    public Cursor<T> cursor() {
        return StandardCursor.of(IndexedArray.retained(this.values));
    }

    @Override
    @Nonnull
    public SplitableIterator<T> iterator() {
        return IndexedIterator.iterator(IndexedArray.retained(this.values));
    }

    @Override
    public void checkInvariants() {
        if (this.values.length == 0 || this.values.length > 32) {
            throw new IllegalStateException();
        }
    }

    Indexed<T> values() {
        return IndexedArray.retained(this.values);
    }
}

