/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.list;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Insertable;
import org.javimmutable.collections.JImmutableStack;
import org.javimmutable.collections.Sequence;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.cursors.SequenceCursor;
import org.javimmutable.collections.iterators.IteratorHelper;
import org.javimmutable.collections.iterators.SequenceIterator;
import org.javimmutable.collections.serialization.JImmutableStackProxy;

@Immutable
public class JImmutableLinkedStack<V>
implements JImmutableStack<V>,
Serializable {
    private static final JImmutableLinkedStack EMPTY = new JImmutableLinkedStack<Object>(null, null);
    private static final long serialVersionUID = -121805L;
    private final V value;
    private final JImmutableLinkedStack<V> next;

    private JImmutableLinkedStack(V value, JImmutableLinkedStack<V> next) {
        this.value = value;
        this.next = next;
    }

    public static <T> JImmutableStack<T> of() {
        return EMPTY;
    }

    public static <T> JImmutableStack<T> of(T value) {
        return new JImmutableLinkedStack<T>(value, EMPTY);
    }

    public static <T> JImmutableStack<T> of(List<T> values) {
        Insertable list = JImmutableLinkedStack.of();
        for (T value : values) {
            list = list.insert((Object)value);
        }
        return list;
    }

    @SafeVarargs
    public static <T> JImmutableStack<T> of(T ... values) {
        Insertable list = JImmutableLinkedStack.of();
        for (T value : values) {
            list = list.insert((Object)value);
        }
        return list;
    }

    @Override
    public boolean isEmpty() {
        return this.next == null;
    }

    @Override
    public V getHead() {
        if (this.next == null) {
            throw new UnsupportedOperationException();
        }
        return this.value;
    }

    @Override
    @Nonnull
    public JImmutableStack<V> getTail() {
        if (this.next == null) {
            return this;
        }
        return this.next;
    }

    @Override
    @Nonnull
    public JImmutableStack<V> insert(@Nullable V value) {
        return new JImmutableLinkedStack<V>(value, this);
    }

    @Override
    @Nonnull
    public JImmutableStack<V> remove() {
        return this.getTail();
    }

    @Override
    public int getSpliteratorCharacteristics() {
        return 1040;
    }

    @Override
    public List<V> makeList() {
        ArrayList answer = new ArrayList();
        Sequence<V> next = this;
        while (!next.isEmpty()) {
            answer.add(next.getHead());
            next = next.getTail();
        }
        return answer;
    }

    public boolean equals(Object o) {
        return o instanceof JImmutableStack && IteratorHelper.iteratorEquals(this.iterator(), ((JImmutableStack)o).iterator());
    }

    public int hashCode() {
        return IteratorHelper.iteratorHashCode(this.iterator());
    }

    public String toString() {
        return IteratorHelper.iteratorToString(this.iterator());
    }

    @Override
    @Nonnull
    public JImmutableStack<V> getInsertableSelf() {
        return this;
    }

    @Override
    @Nonnull
    public Cursor<V> cursor() {
        return SequenceCursor.of(this);
    }

    @Override
    @Nonnull
    public SplitableIterator<V> iterator() {
        return SequenceIterator.iterator(this);
    }

    @Override
    public void checkInvariants() {
        if (this.next == null && this != EMPTY) {
            throw new IllegalStateException();
        }
    }

    private Object writeReplace() {
        return new JImmutableStackProxy(this);
    }
}

