/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.list;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.Insertable;
import org.javimmutable.collections.JImmutableList;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.common.ListAdaptor;
import org.javimmutable.collections.common.Subindexed;
import org.javimmutable.collections.indexed.IndexedList;
import org.javimmutable.collections.iterators.IndexedIterator;
import org.javimmutable.collections.iterators.IteratorHelper;
import org.javimmutable.collections.iterators.SequenceIterator;
import org.javimmutable.collections.list.BranchNode;
import org.javimmutable.collections.list.EmptyNode;
import org.javimmutable.collections.list.Node;
import org.javimmutable.collections.list.TreeBuilder;
import org.javimmutable.collections.sequence.EmptySequenceNode;
import org.javimmutable.collections.serialization.JImmutableListProxy;

public class JImmutableArrayList<T>
implements JImmutableList<T>,
Serializable {
    private static final JImmutableArrayList EMPTY = new JImmutableArrayList(EmptyNode.of());
    private static final long serialVersionUID = -121805L;
    private final Node<T> root;

    private JImmutableArrayList(Node<T> root) {
        this.root = root;
    }

    @Nonnull
    public static <T> JImmutableArrayList<T> of() {
        return EMPTY;
    }

    @Nonnull
    public static <T> JImmutableArrayList<T> of(Indexed<? extends T> source, int offset, int limit) {
        return JImmutableArrayList.of(Subindexed.of(source, offset, limit));
    }

    @Nonnull
    public static <T> JImmutableArrayList<T> of(Indexed<? extends T> source) {
        Node<T> root = BranchNode.of(source);
        return root.isEmpty() ? EMPTY : new JImmutableArrayList<T>(root);
    }

    @Nonnull
    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Nonnull
    public static <T> Collector<T, ?, JImmutableList<T>> collector() {
        return Collector.of(() -> new Builder(), (b, v) -> b.add(v), (b1, b2) -> (Builder)b1.add(((Builder)b2).iterator()), b -> b.build(), new Collector.Characteristics[0]);
    }

    @Override
    public int size() {
        return this.root.size();
    }

    @Override
    public T get(int index) {
        return this.root.get(index);
    }

    @Override
    @Nonnull
    public JImmutableArrayList<T> assign(int index, @Nullable T value) {
        return new JImmutableArrayList<T>(this.root.assign(index, value));
    }

    @Override
    @Nonnull
    public JImmutableArrayList<T> insert(@Nullable T value) {
        return new JImmutableArrayList<T>(this.root.insertLast(value));
    }

    @Override
    @Nonnull
    public JImmutableList<T> getInsertableSelf() {
        return this;
    }

    @Override
    @Nonnull
    public JImmutableArrayList<T> insert(@Nonnull Iterable<? extends T> values) {
        return this.insertAllLast((Iterable)values);
    }

    @Override
    @Nonnull
    public JImmutableArrayList<T> insertFirst(@Nullable T value) {
        return new JImmutableArrayList<T>(this.root.insertFirst(value));
    }

    @Override
    @Nonnull
    public JImmutableArrayList<T> insertLast(@Nullable T value) {
        return new JImmutableArrayList<T>(this.root.insertLast(value));
    }

    @Override
    @Nonnull
    public JImmutableArrayList<T> insertAll(@Nonnull Iterable<? extends T> values) {
        return this.insertAllLast((Iterable)values);
    }

    @Override
    @Nonnull
    public JImmutableArrayList<T> insertAll(@Nonnull Cursor<? extends T> values) {
        return this.insertAllLast((Cursor)values);
    }

    @Override
    @Nonnull
    public JImmutableArrayList<T> insertAll(@Nonnull Iterator<? extends T> values) {
        return this.insertAllLast((Iterator)values);
    }

    @Override
    @Nonnull
    public JImmutableArrayList<T> insertAllFirst(@Nonnull Iterable<? extends T> values) {
        Node<T> newRoot;
        if (values instanceof JImmutableArrayList) {
            Node<T> other = ((JImmutableArrayList)values).root;
            newRoot = other.size() > this.root.size() ? other.insertAll(Integer.MAX_VALUE, true, this.root.iterator()) : this.root.insertAll(Integer.MAX_VALUE, false, IndexedIterator.reverse(other));
        } else if (values instanceof Indexed) {
            Indexed indexed = (Indexed)((Object)values);
            newRoot = this.root.insertAll(Integer.MAX_VALUE, false, IndexedIterator.reverse(indexed));
        } else if (values instanceof List) {
            IndexedList indexed = IndexedList.retained((List)values);
            newRoot = this.root.insertAll(Integer.MAX_VALUE, false, IndexedIterator.reverse(indexed));
        } else {
            Iterator<T> iterator = values.iterator();
            Insertable seq = EmptySequenceNode.of();
            while (iterator.hasNext()) {
                seq = seq.insert((Object)iterator.next());
            }
            newRoot = this.root.insertAll(Integer.MAX_VALUE, false, SequenceIterator.iterator(seq));
        }
        return newRoot != this.root ? new JImmutableArrayList<T>(newRoot) : this;
    }

    @Override
    @Nonnull
    public JImmutableArrayList<T> insertAllFirst(@Nonnull Cursor<? extends T> values) {
        return this.insertAllFirst(values.iterator());
    }

    @Override
    @Nonnull
    public JImmutableArrayList<T> insertAllFirst(@Nonnull Iterator<? extends T> values) {
        Insertable seq = EmptySequenceNode.of();
        while (values.hasNext()) {
            seq = seq.insert((Object)values.next());
        }
        Node<T> newRoot = this.root.insertAll(Integer.MAX_VALUE, false, SequenceIterator.iterator(seq));
        return newRoot != this.root ? new JImmutableArrayList<T>(newRoot) : this;
    }

    @Override
    @Nonnull
    public JImmutableArrayList<T> insertAllLast(@Nonnull Iterable<? extends T> values) {
        Node<T> other;
        if (values instanceof JImmutableArrayList && (other = ((JImmutableArrayList)values).root).size() > this.root.size()) {
            Node<T> newRoot = other.insertAll(Integer.MAX_VALUE, false, IndexedIterator.reverse(this.root));
            return newRoot != this.root ? new JImmutableArrayList<T>(newRoot) : this;
        }
        return this.insertAllLast(values.iterator());
    }

    @Override
    @Nonnull
    public JImmutableArrayList<T> insertAllLast(@Nonnull Cursor<? extends T> values) {
        return this.insertAllLast(values.iterator());
    }

    @Override
    @Nonnull
    public JImmutableArrayList<T> insertAllLast(@Nonnull Iterator<? extends T> values) {
        Node<? extends T> newRoot = this.root.insertAll(Integer.MAX_VALUE, true, values);
        return newRoot != this.root ? new JImmutableArrayList<T>(newRoot) : this;
    }

    @Nonnull
    JImmutableArrayList<T> insertAllFirstOldWay(@Nonnull Iterator<? extends T> values) {
        Object seq = EmptySequenceNode.of();
        while (values.hasNext()) {
            seq = seq.insert((Object)values.next());
        }
        Node newRoot = this.root;
        while (!seq.isEmpty()) {
            newRoot = newRoot.insertFirst(seq.getHead());
            seq = seq.getTail();
        }
        return newRoot != this.root ? new JImmutableArrayList<T>(newRoot) : this;
    }

    @Nonnull
    JImmutableArrayList<T> insertAllLastOldWay(@Nonnull Iterator<? extends T> values) {
        Node<T> newRoot = this.root;
        while (values.hasNext()) {
            newRoot = newRoot.insertLast(values.next());
        }
        return new JImmutableArrayList<T>(newRoot);
    }

    @Override
    @Nonnull
    public JImmutableArrayList<T> deleteFirst() {
        if (this.root.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        return new JImmutableArrayList<T>(this.root.deleteFirst());
    }

    @Override
    @Nonnull
    public JImmutableArrayList<T> deleteLast() {
        if (this.root.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        return new JImmutableArrayList<T>(this.root.deleteLast());
    }

    @Override
    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    @Override
    @Nonnull
    public JImmutableArrayList<T> deleteAll() {
        return JImmutableArrayList.of();
    }

    @Override
    @Nonnull
    public List<T> getList() {
        return ListAdaptor.of(this);
    }

    @Override
    @Nonnull
    public Cursor<T> cursor() {
        return this.root.cursor();
    }

    @Override
    @Nonnull
    public SplitableIterator<T> iterator() {
        return this.root.iterator();
    }

    @Override
    public <A> JImmutableList<A> transform(@Nonnull Func1<T, A> transform) {
        Builder<T> builder = JImmutableArrayList.builder();
        for (Object t : this.root) {
            builder.add(transform.apply((T)t));
        }
        return builder.build();
    }

    @Override
    public <A> JImmutableList<A> transformSome(@Nonnull Func1<T, Holder<A>> transform) {
        Builder<T> builder = JImmutableArrayList.builder();
        for (Object t : this.root) {
            Holder<A> ha = transform.apply((T)t);
            if (!ha.isFilled()) continue;
            builder.add(ha.getValue());
        }
        return builder.build();
    }

    @Override
    public int getSpliteratorCharacteristics() {
        return 1040;
    }

    @Override
    public void checkInvariants() {
        this.root.checkInvariants();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof JImmutableList && IteratorHelper.iteratorEquals(this.iterator(), ((JImmutableList)o).iterator());
    }

    public int hashCode() {
        return IteratorHelper.iteratorHashCode(this.iterator());
    }

    public String toString() {
        return IteratorHelper.iteratorToString(this.iterator());
    }

    private Object writeReplace() {
        return new JImmutableListProxy(this);
    }

    public static class Builder<T>
    implements JImmutableList.Builder<T> {
        private final TreeBuilder<T> builder = new TreeBuilder(true);

        private Builder() {
        }

        @Override
        public int size() {
            return this.builder.size();
        }

        @Nonnull
        public Builder<T> add(T value) {
            this.builder.add(value);
            return this;
        }

        @Override
        @Nonnull
        public JImmutableArrayList<T> build() {
            return this.builder.size() == 0 ? JImmutableArrayList.of() : new JImmutableArrayList(this.builder.build());
        }

        @Nonnull
        private Iterator<T> iterator() {
            return this.builder.build().iterator();
        }
    }
}

