/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.list;

import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.cursors.StandardCursor;
import org.javimmutable.collections.iterators.EmptyIterator;
import org.javimmutable.collections.list.LeafNode;
import org.javimmutable.collections.list.Node;
import org.javimmutable.collections.list.TreeBuilder;

@Immutable
final class EmptyNode<T>
implements Node<T> {
    private static final EmptyNode INSTANCE = new EmptyNode();

    private EmptyNode() {
    }

    static <T> EmptyNode<T> of() {
        return INSTANCE;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean isFull() {
        return false;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public int getDepth() {
        return 1;
    }

    @Override
    public Node<T> deleteFirst() {
        throw new IllegalStateException();
    }

    @Override
    public Node<T> deleteLast() {
        throw new IllegalStateException();
    }

    @Override
    public Node<T> insertFirst(T value) {
        return new LeafNode<T>(value);
    }

    @Override
    public Node<T> insertLast(T value) {
        return new LeafNode<T>(value);
    }

    @Override
    public boolean containsIndex(int index) {
        return false;
    }

    @Override
    public T get(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Node<T> assign(int index, T value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Node<T> insertAll(int maxSize, boolean forwardOrder, @Nonnull Iterator<? extends T> values) {
        return TreeBuilder.createFromIterator(maxSize, forwardOrder, values);
    }

    @Override
    @Nonnull
    public Cursor<T> cursor() {
        return StandardCursor.of();
    }

    @Override
    @Nonnull
    public SplitableIterator<T> iterator() {
        return EmptyIterator.of();
    }

    @Override
    public void checkInvariants() {
    }
}

