/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.list;

import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Cursorable;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.SplitableIterable;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.cursors.LazyMultiCursor;
import org.javimmutable.collections.indexed.IndexedArray;
import org.javimmutable.collections.iterators.LazyMultiIterator;
import org.javimmutable.collections.list.EmptyNode;
import org.javimmutable.collections.list.LeafNode;
import org.javimmutable.collections.list.ListHelper;
import org.javimmutable.collections.list.Node;
import org.javimmutable.collections.list.TreeBuilder;

@Immutable
class BranchNode<T>
implements Node<T> {
    private final int depth;
    private final int size;
    private final Node<T> prefix;
    private final Node<T>[] nodes;
    private final Node<T> suffix;

    private BranchNode(int depth, int size, Node<T> prefix, Node<T>[] nodes, Node<T> suffix) {
        assert (nodes.length <= 32);
        assert (size <= ListHelper.sizeForDepth(depth));
        this.depth = depth;
        this.size = size;
        this.prefix = prefix;
        this.nodes = nodes;
        this.suffix = suffix;
    }

    BranchNode(T prefixValue, Node<T> node) {
        this(node.getDepth() + 1, node.size() + 1, new LeafNode<T>(prefixValue), ListHelper.allocateSingleNode(node), EmptyNode.of());
        assert (node.isFull());
    }

    BranchNode(Node<T> node) {
        this(node.getDepth() + 1, node.size() + 1, EmptyNode.of(), ListHelper.allocateSingleNode(node), EmptyNode.of());
        assert (node.isFull());
    }

    BranchNode(Node<T> node, T suffixValue) {
        this(node.getDepth() + 1, node.size() + 1, EmptyNode.of(), ListHelper.allocateSingleNode(node), new LeafNode<T>(suffixValue));
        assert (node.isFull());
    }

    static <T> Node<T> forNodeBuilder(int depth, int size, Node<T> prefix, Indexed<Node<T>> sourceNodes, int offset, int limit, Node<T> suffix) {
        assert (limit > offset);
        assert (ListHelper.allNodesFull(depth, sourceNodes, offset, limit));
        Node<T>[] nodes = ListHelper.allocateNodes(sourceNodes, offset, limit);
        return new BranchNode<T>(depth, size, prefix, nodes, suffix);
    }

    static <T> Node<T> of(Indexed<? extends T> leaves) {
        int nodeCount = leaves.size();
        if (nodeCount == 0) {
            return EmptyNode.of();
        }
        if (nodeCount <= 32) {
            return LeafNode.fromList(leaves, 0, nodeCount);
        }
        Node<T>[] nodes = ListHelper.allocateNodes(1 + leaves.size() / 32);
        int index = 0;
        for (int offset = 0; offset < nodeCount; offset += 32) {
            nodes[index++] = LeafNode.fromList(leaves, offset, Math.min(offset + 32, nodeCount));
        }
        nodeCount = index;
        int depth = 2;
        while (nodeCount > 1) {
            int dstOffset = 0;
            int srcOffset = 0;
            while (nodeCount > 32) {
                Node<T>[] newNodes = ListHelper.allocateNodes(32);
                System.arraycopy(nodes, srcOffset, newNodes, 0, 32);
                nodes[dstOffset++] = new BranchNode(depth, ListHelper.sizeForDepth(depth), EmptyNode.of(), newNodes, EmptyNode.of());
                srcOffset += 32;
                nodeCount -= 32;
            }
            if (nodeCount == 1) {
                nodes[dstOffset++] = nodes[srcOffset];
            } else if (nodeCount > 1) {
                Node lastNode = nodes[srcOffset + nodeCount - 1];
                if (lastNode.getDepth() == depth - 1 && lastNode.isFull()) {
                    Node<T>[] newNodes = ListHelper.allocateNodes(nodeCount);
                    System.arraycopy(nodes, srcOffset, newNodes, 0, nodeCount);
                    nodes[dstOffset++] = new BranchNode(depth, ListHelper.sizeForDepth(depth - 1) * nodeCount, EmptyNode.of(), newNodes, EmptyNode.of());
                } else {
                    int newNodesLength = nodeCount - 1;
                    Node<T>[] newNodes = ListHelper.allocateNodes(newNodesLength);
                    System.arraycopy(nodes, srcOffset, newNodes, 0, newNodesLength);
                    nodes[dstOffset++] = new BranchNode(depth, ListHelper.sizeForDepth(depth - 1) * newNodesLength + lastNode.size(), EmptyNode.of(), newNodes, lastNode);
                }
            }
            nodeCount = dstOffset;
            ++depth;
        }
        assert (nodeCount == 1);
        return nodes[0];
    }

    static <T> BranchNode<T> forTesting(Node<T> prefix, Node<T>[] nodes, Node<T> suffix) {
        return new BranchNode<T>(2, prefix.size() + nodes.length * 32 + suffix.size(), prefix, (Node[])nodes.clone(), suffix);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean isFull() {
        return this.size == ListHelper.sizeForDepth(this.depth);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    private static <T> Node<T> forDelete(int size, Node<T> prefix, Node<T>[] nodes, Node<T> suffix) {
        if (nodes.length == 0) {
            if (prefix.isEmpty()) {
                return suffix;
            }
            if (suffix.isEmpty()) {
                return prefix;
            }
            int depth = 1 + Math.max(prefix.getDepth(), suffix.getDepth());
            return new BranchNode<T>(depth, size, prefix, nodes, suffix);
        }
        if (nodes.length == 1 && prefix.isEmpty() && suffix.isEmpty()) {
            return nodes[0];
        }
        int depth = 1 + nodes[0].getDepth();
        return new BranchNode<T>(depth, size, prefix, nodes, suffix);
    }

    @Override
    public Node<T> deleteFirst() {
        if (!this.prefix.isEmpty()) {
            return BranchNode.forDelete(this.size - 1, this.prefix.deleteFirst(), this.nodes, this.suffix);
        }
        if (this.nodes.length > 0) {
            Node<T> newPrefix = this.nodes[0];
            Node<T>[] newNodes = ListHelper.allocateNodes(this.nodes.length - 1);
            System.arraycopy(this.nodes, 1, newNodes, 0, newNodes.length);
            return BranchNode.forDelete(this.size - 1, newPrefix.deleteFirst(), newNodes, this.suffix);
        }
        if (!this.suffix.isEmpty()) {
            return this.suffix.deleteFirst();
        }
        throw new IllegalStateException();
    }

    @Override
    public Node<T> deleteLast() {
        if (!this.suffix.isEmpty()) {
            return BranchNode.forDelete(this.size - 1, this.prefix, this.nodes, this.suffix.deleteLast());
        }
        if (this.nodes.length > 0) {
            Node<T> newSuffix = this.nodes[this.nodes.length - 1];
            Node<T>[] newNodes = ListHelper.allocateNodes(this.nodes.length - 1);
            System.arraycopy(this.nodes, 0, newNodes, 0, newNodes.length);
            return BranchNode.forDelete(this.size - 1, this.prefix, newNodes, newSuffix.deleteLast());
        }
        if (!this.prefix.isEmpty()) {
            return this.prefix.deleteLast();
        }
        throw new IllegalStateException();
    }

    @Override
    public Node<T> insertFirst(T value) {
        Node<T>[] newNodes;
        if (this.isFull()) {
            return new BranchNode<T>(value, this);
        }
        if (this.prefix.getDepth() < this.depth - 1) {
            return new BranchNode<T>(this.depth, this.size + 1, this.prefix.insertFirst(value), this.nodes, this.suffix);
        }
        assert (this.prefix.getDepth() == this.depth - 1);
        assert (!this.prefix.isFull());
        Node<T> newPrefix = this.prefix.insertFirst(value);
        if (newPrefix.isFull()) {
            newNodes = ListHelper.allocateNodes(this.nodes.length + 1);
            System.arraycopy(this.nodes, 0, newNodes, 1, this.nodes.length);
            newNodes[0] = newPrefix;
            newPrefix = EmptyNode.of();
        } else {
            newNodes = this.nodes;
        }
        return new BranchNode<T>(this.depth, this.size + 1, newPrefix, newNodes, this.suffix);
    }

    @Override
    public Node<T> insertLast(T value) {
        Node<T>[] newNodes;
        if (this.isFull()) {
            return new BranchNode<T>(this, value);
        }
        if (this.suffix.getDepth() < this.depth - 1) {
            return new BranchNode<T>(this.depth, this.size + 1, this.prefix, this.nodes, this.suffix.insertLast(value));
        }
        assert (this.suffix.getDepth() == this.depth - 1);
        assert (!this.suffix.isFull());
        Node<T> newSuffix = this.suffix.insertLast(value);
        if (newSuffix.isFull()) {
            newNodes = ListHelper.allocateNodes(this.nodes.length + 1);
            System.arraycopy(this.nodes, 0, newNodes, 0, this.nodes.length);
            newNodes[this.nodes.length] = newSuffix;
            newSuffix = EmptyNode.of();
        } else {
            newNodes = this.nodes;
        }
        return new BranchNode<T>(this.depth, this.size + 1, this.prefix, newNodes, newSuffix);
    }

    @Override
    public boolean containsIndex(int index) {
        return index >= 0 && index < this.size;
    }

    @Override
    public T get(int index) {
        int fullNodeSize;
        if (this.prefix.containsIndex(index)) {
            return this.prefix.get(index);
        }
        int arrayIndex = (index -= this.prefix.size()) / (fullNodeSize = ListHelper.sizeForDepth(this.depth - 1));
        if (arrayIndex < this.nodes.length) {
            return this.nodes[arrayIndex].get(index - arrayIndex * fullNodeSize);
        }
        if (this.suffix.containsIndex(index -= this.nodes.length * fullNodeSize)) {
            return this.suffix.get(index);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Node<T> assign(int index, T value) {
        int fullNodeSize;
        if (this.prefix.containsIndex(index)) {
            return new BranchNode<T>(this.depth, this.size, this.prefix.assign(index, value), this.nodes, this.suffix);
        }
        int arrayIndex = (index -= this.prefix.size()) / (fullNodeSize = ListHelper.sizeForDepth(this.depth - 1));
        if (arrayIndex < this.nodes.length) {
            Node[] newNodes = (Node[])this.nodes.clone();
            newNodes[arrayIndex] = this.nodes[arrayIndex].assign(index - arrayIndex * fullNodeSize, value);
            return new BranchNode<T>(this.depth, this.size, this.prefix, newNodes, this.suffix);
        }
        if (this.suffix.containsIndex(index -= this.nodes.length * fullNodeSize)) {
            return new BranchNode<T>(this.depth, this.size, this.prefix, this.nodes, this.suffix.assign(index, value));
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Node<T> insertAll(int maxSize, boolean forwardOrder, @Nonnull Iterator<? extends T> values) {
        BranchNode<T> newNode;
        assert (maxSize >= this.size);
        assert (ListHelper.sizeForDepth(this.depth) >= this.size);
        if (this.size >= maxSize || !values.hasNext()) {
            return this;
        }
        int fullSize = Math.min(ListHelper.sizeForDepth(this.depth), maxSize);
        int growthAllowed = fullSize - this.size;
        if (this.isFull()) {
            newNode = this;
        } else if (forwardOrder) {
            if (this.suffix.isEmpty()) {
                newNode = this;
            } else {
                int maxSuffixSize = Math.min(ListHelper.sizeForDepth(this.depth - 1), this.suffix.size() + growthAllowed);
                Node<? extends T> newSuffix = this.suffix.insertAll(maxSuffixSize, true, values);
                newNode = super.withSuffix(newSuffix);
            }
            if (values.hasNext() && newNode.size() < maxSize && !newNode.isFull()) {
                assert (newNode.suffix.isEmpty());
                newNode = super.withPrefix(this.prefix);
            }
        } else {
            if (this.prefix.isEmpty()) {
                newNode = this;
            } else {
                int maxPrefixSize = Math.min(ListHelper.sizeForDepth(this.depth - 1), this.prefix.size() + growthAllowed);
                Node<? extends T> newPrefix = this.prefix.insertAll(maxPrefixSize, false, values);
                newNode = super.withPrefix(newPrefix);
            }
            if (values.hasNext() && newNode.size() < maxSize && !newNode.isFull()) {
                assert (newNode.prefix.isEmpty());
                newNode = super.withSuffix(this.suffix);
            }
        }
        assert (newNode.isFull() || newNode.size == maxSize || !values.hasNext());
        if (newNode.size() < maxSize && values.hasNext()) {
            newNode = TreeBuilder.expandBranchNode(maxSize, forwardOrder, new BranchNode<T>(newNode), values);
        }
        assert (newNode.size() == maxSize || !values.hasNext());
        return newNode;
    }

    @Override
    @Nonnull
    public Cursor<T> cursor() {
        return LazyMultiCursor.cursor(this.indexedForCursor());
    }

    @Override
    @Nonnull
    public SplitableIterator<T> iterator() {
        return LazyMultiIterator.iterator(this.indexedForIterator());
    }

    private Indexed<Cursorable<T>> indexedForCursor() {
        final int last = this.nodes.length + 1;
        return new Indexed<Cursorable<T>>(){

            @Override
            public Cursorable<T> get(int index) {
                return BranchNode.this.getNode(index, last);
            }

            @Override
            public int size() {
                return last + 1;
            }
        };
    }

    private Indexed<SplitableIterable<T>> indexedForIterator() {
        final int last = this.nodes.length + 1;
        return new Indexed<SplitableIterable<T>>(){

            @Override
            public SplitableIterable<T> get(int index) {
                return BranchNode.this.getNode(index, last);
            }

            @Override
            public int size() {
                return last + 1;
            }
        };
    }

    private Node<T> getNode(int index, int last) {
        if (index == 0) {
            return this.prefix;
        }
        if (index == last) {
            return this.suffix;
        }
        return this.nodes[index - 1];
    }

    @Override
    public void checkInvariants() {
        if (this.nodes.length > 32) {
            throw new IllegalStateException();
        }
        if (!(this.nodes.length != 32 || this.prefix.isEmpty() && this.suffix.isEmpty())) {
            throw new IllegalStateException();
        }
        for (Node<T> node : this.nodes) {
            if (node.getDepth() == this.depth - 1 && node.isFull()) continue;
            throw new IllegalStateException();
        }
        int computedSize = this.prefix.size() + this.suffix.size();
        for (Node<T> node : this.nodes) {
            computedSize += node.size();
        }
        if (computedSize != this.size) {
            throw new IllegalStateException();
        }
        if (this.prefix.isFull() && this.prefix.getDepth() == this.depth - 1) {
            throw new IllegalStateException();
        }
        if (this.suffix.isFull() && this.suffix.getDepth() == this.depth - 1) {
            throw new IllegalStateException();
        }
        this.prefix.checkInvariants();
        for (Node<T> node : this.nodes) {
            node.checkInvariants();
        }
        this.suffix.checkInvariants();
    }

    Node<T> prefix() {
        return this.prefix;
    }

    Indexed<Node<T>> filledNodes() {
        return IndexedArray.retained(this.nodes);
    }

    Node<T> suffix() {
        return this.suffix;
    }

    private BranchNode<T> withPrefix(@Nonnull Node<T> newPrefix) {
        assert (newPrefix.getDepth() < this.depth);
        int baseSize = this.size - this.prefix.size();
        if (newPrefix.size() == ListHelper.sizeForDepth(this.depth - 1)) {
            Node<T>[] newNodes = ListHelper.allocateNodes(this.nodes.length + 1);
            System.arraycopy(this.nodes, 0, newNodes, 1, this.nodes.length);
            newNodes[0] = newPrefix;
            return new BranchNode(this.depth, baseSize + newPrefix.size(), EmptyNode.of(), newNodes, this.suffix);
        }
        return new BranchNode<T>(this.depth, baseSize + newPrefix.size(), newPrefix, this.nodes, this.suffix);
    }

    private BranchNode<T> withSuffix(@Nonnull Node<T> newSuffix) {
        assert (newSuffix.getDepth() < this.depth);
        int baseSize = this.size - this.suffix.size();
        if (newSuffix.size() == ListHelper.sizeForDepth(this.depth - 1)) {
            Node<T>[] newNodes = ListHelper.allocateNodes(this.nodes.length + 1);
            System.arraycopy(this.nodes, 0, newNodes, 0, this.nodes.length);
            newNodes[this.nodes.length] = newSuffix;
            return new BranchNode<T>(this.depth, baseSize + newSuffix.size(), this.prefix, newNodes, EmptyNode.of());
        }
        return new BranchNode<T>(this.depth, baseSize + newSuffix.size(), this.prefix, this.nodes, newSuffix);
    }
}

