/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.iterators;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.SplitIterator;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.iterators.AbstractSplitableIterator;

@Immutable
public class TransformIterator<S, T>
extends AbstractSplitableIterator<T> {
    private final Function<S, T> transforminator;
    private final SplitableIterator<S> source;

    private TransformIterator(@Nonnull SplitableIterator<S> source, @Nonnull Function<S, T> transforminator) {
        this.transforminator = transforminator;
        this.source = source;
    }

    public static <S, T> TransformIterator<S, T> of(@Nonnull SplitableIterator<S> source, @Nonnull Function<S, T> transforminator) {
        return new TransformIterator<S, T>(source, transforminator);
    }

    @Override
    public boolean hasNext() {
        return this.source.hasNext();
    }

    @Override
    public T next() {
        return this.transforminator.apply(this.source.next());
    }

    @Override
    public boolean isSplitAllowed() {
        return this.source.isSplitAllowed();
    }

    @Override
    @Nonnull
    public SplitIterator<T> splitIterator() {
        SplitIterator<S> split = this.source.splitIterator();
        return new SplitIterator(new TransformIterator<S, T>(split.getLeft(), this.transforminator), new TransformIterator<S, T>(split.getRight(), this.transforminator));
    }
}

