/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.iterators;

import java.util.Iterator;
import javax.annotation.Nonnull;

public class IteratorHelper {
    public static boolean iteratorEquals(@Nonnull Iterator<?> a, @Nonnull Iterator<?> b) {
        while (a.hasNext() && b.hasNext()) {
            Object bv;
            Object av = a.next();
            if (av == (bv = b.next()) || av != null && av.equals(bv)) continue;
            return false;
        }
        return a.hasNext() == b.hasNext();
    }

    public static int iteratorHashCode(@Nonnull Iterator<?> a) {
        int hashCode = 0;
        while (a.hasNext()) {
            Object value = a.next();
            int valueHashCode = value == null ? 0 : value.hashCode();
            hashCode = 31 * hashCode + valueHashCode;
        }
        return hashCode;
    }

    public static String iteratorToString(Iterator<?> iterator) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        while (iterator.hasNext()) {
            Object value;
            if (sb.length() > 1) {
                sb.append(",");
            }
            if ((value = iterator.next()) == null) {
                sb.append("null");
                continue;
            }
            sb.append(value);
        }
        sb.append("]");
        return sb.toString();
    }
}

