/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.iterators;

import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.SplitIterator;
import org.javimmutable.collections.SplitableIterable;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.indexed.IndexedHelper;
import org.javimmutable.collections.iterators.AbstractSplitableIterator;

public final class IndexedIterator {
    private IndexedIterator() {
    }

    public static <T> SplitableIterator<T> forward(@Nonnull Indexed<T> values) {
        return new Forward<T>(values, -1, values.size() - 1);
    }

    public static <T> SplitableIterable<T> fwd(@Nonnull Indexed<T> values) {
        return () -> IndexedIterator.forward(values);
    }

    public static <T> SplitableIterator<T> iterator(@Nonnull Indexed<T> values) {
        return IndexedIterator.forward(values);
    }

    public static <T> SplitableIterator<T> reverse(@Nonnull Indexed<T> values) {
        return new Reverse<T>(values, values.size(), 0);
    }

    public static <T> SplitableIterable<T> rev(@Nonnull Indexed<T> values) {
        return () -> IndexedIterator.reverse(values);
    }

    public static SplitableIterator<Integer> forRange(int low, int high) {
        return IndexedIterator.iterator(IndexedHelper.range(low, high));
    }

    private static class Reverse<T>
    extends AbstractSplitableIterator<T> {
        @Nonnull
        private final Indexed<T> values;
        private final int limit;
        private int index;

        public Reverse(@Nonnull Indexed<T> values, int index, int limit) {
            this.values = values;
            this.limit = limit;
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index > this.limit;
        }

        @Override
        public T next() {
            if (this.index <= this.limit) {
                throw new NoSuchElementException();
            }
            --this.index;
            return this.values.get(this.index);
        }

        @Override
        public boolean isSplitAllowed() {
            return this.index - this.limit > 1;
        }

        @Override
        @Nonnull
        public SplitIterator<T> splitIterator() {
            int splitIndex = this.index - (this.index - this.limit) / 2;
            if (splitIndex == this.index) {
                throw new UnsupportedOperationException();
            }
            return new SplitIterator<T>(new Reverse<T>(this.values, this.index, splitIndex), new Reverse<T>(this.values, splitIndex, this.limit));
        }
    }

    private static class Forward<T>
    extends AbstractSplitableIterator<T> {
        @Nonnull
        private final Indexed<T> values;
        private final int limit;
        private int index;

        public Forward(@Nonnull Indexed<T> values, int index, int limit) {
            this.values = values;
            this.limit = limit;
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.limit;
        }

        @Override
        public T next() {
            if (this.index >= this.limit) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return this.values.get(this.index);
        }

        @Override
        public boolean isSplitAllowed() {
            return this.limit - this.index > 1;
        }

        @Override
        @Nonnull
        public SplitIterator<T> splitIterator() {
            int splitIndex = this.index + (this.limit - this.index) / 2;
            if (splitIndex == this.index) {
                throw new UnsupportedOperationException();
            }
            return new SplitIterator<T>(new Forward<T>(this.values, this.index, splitIndex), new Forward<T>(this.values, splitIndex, this.limit));
        }
    }
}

