/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.inorder;

import java.io.Serializable;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.GenericCollector;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.MapEntry;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.array.JImmutableTrieArray;
import org.javimmutable.collections.common.AbstractJImmutableMap;
import org.javimmutable.collections.cursors.TransformCursor;
import org.javimmutable.collections.hash.JImmutableHashMap;
import org.javimmutable.collections.iterators.TransformIterator;
import org.javimmutable.collections.serialization.JImmutableInsertOrderMapProxy;

@Immutable
public class JImmutableInsertOrderMap<K, V>
extends AbstractJImmutableMap<K, V>
implements Serializable {
    public static final JImmutableInsertOrderMap EMPTY = new JImmutableInsertOrderMap(JImmutableTrieArray.of(), JImmutableHashMap.of(), Integer.MIN_VALUE);
    private static final long serialVersionUID = -121805L;
    private final JImmutableTrieArray<Node<K, V>> sortedNodes;
    private final JImmutableMap<K, Node<K, V>> hashedNodes;
    private final int nextIndex;

    private JImmutableInsertOrderMap(JImmutableTrieArray<Node<K, V>> sortedNodes, JImmutableMap<K, Node<K, V>> hashedNodes, int nextIndex) {
        assert (sortedNodes.size() == hashedNodes.size());
        this.sortedNodes = sortedNodes;
        this.hashedNodes = hashedNodes;
        this.nextIndex = nextIndex;
    }

    public static <K, V> JImmutableInsertOrderMap<K, V> of() {
        return EMPTY;
    }

    @Override
    public V getValueOr(K key, V defaultValue) {
        Node current = (Node)this.hashedNodes.get(key);
        return current != null ? current.getValue() : defaultValue;
    }

    @Override
    @Nonnull
    public Holder<V> find(@Nonnull K key) {
        Node current = (Node)this.hashedNodes.get(key);
        return current != null ? current : Holders.of();
    }

    @Override
    @Nonnull
    public Holder<JImmutableMap.Entry<K, V>> findEntry(@Nonnull K key) {
        Node current = (Node)this.hashedNodes.get(key);
        return current != null ? Holders.of(current) : Holders.of();
    }

    @Override
    @Nonnull
    public JImmutableInsertOrderMap<K, V> assign(@Nonnull K key, V value) {
        Node current = (Node)this.hashedNodes.get(key);
        if (current == null) {
            Node newNode = new Node(key, value, this.nextIndex);
            return new JImmutableInsertOrderMap(this.sortedNodes.assign(newNode.index, (Object)newNode), this.hashedNodes.assign(key, newNode), this.nextIndex + 1);
        }
        if (current.getValue() == value) {
            return this;
        }
        Node newNode = current.withValue(value);
        return new JImmutableInsertOrderMap<K, V>(this.sortedNodes.assign(newNode.index, (Object)newNode), this.hashedNodes.assign(key, newNode), this.nextIndex);
    }

    @Override
    @Nonnull
    public JImmutableInsertOrderMap<K, V> delete(@Nonnull K key) {
        Node current = (Node)this.hashedNodes.get(key);
        if (current != null) {
            return new JImmutableInsertOrderMap<K, V>(this.sortedNodes.delete(current.index), this.hashedNodes.delete(key), this.nextIndex);
        }
        return this;
    }

    @Override
    public int size() {
        return this.hashedNodes.size();
    }

    @Override
    @Nonnull
    public JImmutableInsertOrderMap<K, V> deleteAll() {
        return JImmutableInsertOrderMap.of();
    }

    @Override
    @Nonnull
    public Cursor<JImmutableMap.Entry<K, V>> cursor() {
        return TransformCursor.of(this.sortedNodes.cursor(), e -> (Node)e.getValue());
    }

    @Override
    @Nonnull
    public SplitableIterator<JImmutableMap.Entry<K, V>> iterator() {
        return TransformIterator.of(this.sortedNodes.iterator(), e -> (Node)e.getValue());
    }

    @Override
    public int getSpliteratorCharacteristics() {
        return 1040;
    }

    @Override
    @Nonnull
    public Collector<JImmutableMap.Entry<K, V>, ?, JImmutableMap<K, V>> mapCollector() {
        return GenericCollector.ordered(this, this.deleteAll(), a -> a.isEmpty(), (a, v) -> a.insert(v), (a, b) -> (JImmutableMap)a.insertAll(b));
    }

    @Override
    public void checkInvariants() {
    }

    private Object writeReplace() {
        return new JImmutableInsertOrderMapProxy(this);
    }

    @Immutable
    private static class Node<K, V>
    extends MapEntry<K, V>
    implements Holders.Filled<V> {
        private final int index;

        private Node(K key, V value, int index) {
            super(key, value);
            this.index = index;
        }

        private Node<K, V> withValue(V value) {
            return new Node<Object, V>(this.key, value, this.index);
        }
    }
}

