/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.indexed;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.javimmutable.collections.Indexed;

public class IndexedHelper {
    private IndexedHelper() {
    }

    @Nonnull
    public static <T> Indexed<T> empty() {
        return new Indexed<T>(){

            @Override
            public T get(int index) {
                throw new ArrayIndexOutOfBoundsException();
            }

            @Override
            public int size() {
                return 0;
            }
        };
    }

    @Nonnull
    public static <T, V extends T> Indexed<T> indexed(final V a) {
        return new Indexed<T>(){

            @Override
            public T get(int index) {
                switch (index) {
                    case 0: {
                        return a;
                    }
                }
                throw new ArrayIndexOutOfBoundsException();
            }

            @Override
            public int size() {
                return 1;
            }
        };
    }

    @Nonnull
    public static <T, V extends T> Indexed<T> indexed(final V a, final V b) {
        return new Indexed<T>(){

            @Override
            public T get(int index) {
                switch (index) {
                    case 0: {
                        return a;
                    }
                    case 1: {
                        return b;
                    }
                }
                throw new ArrayIndexOutOfBoundsException();
            }

            @Override
            public int size() {
                return 2;
            }
        };
    }

    @Nonnull
    public static <T, V extends T> Indexed<T> indexed(final V a, final V b, final V c) {
        return new Indexed<T>(){

            @Override
            public T get(int index) {
                switch (index) {
                    case 0: {
                        return a;
                    }
                    case 1: {
                        return b;
                    }
                    case 2: {
                        return c;
                    }
                }
                throw new ArrayIndexOutOfBoundsException();
            }

            @Override
            public int size() {
                return 3;
            }
        };
    }

    @Nonnull
    public static <T, V extends T> Indexed<T> indexed(final V a, final V b, final V c, final V ... others) {
        final int length = 3 + others.length;
        return new Indexed<T>(){

            @Override
            public T get(int index) {
                switch (index) {
                    case 0: {
                        return a;
                    }
                    case 1: {
                        return b;
                    }
                    case 2: {
                        return c;
                    }
                }
                return others[index - 3];
            }

            @Override
            public int size() {
                return length;
            }
        };
    }

    @Nonnull
    public static <T> Indexed<T> repeating(final T value, final int count) {
        return new Indexed<T>(){

            @Override
            public T get(int index) {
                if (index < 0 || index >= count) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return value;
            }

            @Override
            public int size() {
                return count;
            }
        };
    }

    @Nonnull
    public static Indexed<Integer> range(final int low, int high) {
        final int size = high - low + 1;
        return new Indexed<Integer>(){

            @Override
            public Integer get(int index) {
                if (index < 0 || index >= size) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return low + index;
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    @Nonnull
    public static <T> List<T> asList(@Nonnull Indexed<T> indexed) {
        ArrayList<T> answer = new ArrayList<T>(indexed.size());
        for (int i = 0; i < indexed.size(); ++i) {
            answer.add(indexed.get(i));
        }
        return answer;
    }
}

