/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.hash.hamt;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.common.MutableDelta;
import org.javimmutable.collections.cursors.SingleValueCursor;
import org.javimmutable.collections.hash.collision_map.CollisionMap;
import org.javimmutable.collections.hash.hamt.HamtBranchNode;
import org.javimmutable.collections.hash.hamt.HamtEmptyNode;
import org.javimmutable.collections.hash.hamt.HamtNode;
import org.javimmutable.collections.iterators.SingleValueIterator;

public class HamtLeafNode<T, K, V>
implements HamtNode<T, K, V> {
    private final int hashCode;
    @Nonnull
    private final T value;

    HamtLeafNode(int hashCode, @Nonnull T value) {
        this.hashCode = hashCode;
        this.value = value;
    }

    @Override
    public Holder<V> find(@Nonnull CollisionMap<T, K, V> collisionMap, int hashCode, @Nonnull K hashKey) {
        if (hashCode == this.hashCode) {
            return collisionMap.findValue(this.value, hashKey);
        }
        return Holders.of();
    }

    @Override
    public V getValueOr(@Nonnull CollisionMap<T, K, V> collisionMap, int hashCode, @Nonnull K hashKey, V defaultValue) {
        if (hashCode == this.hashCode) {
            return collisionMap.getValueOr(this.value, hashKey, defaultValue);
        }
        return defaultValue;
    }

    @Override
    @Nonnull
    public HamtNode<T, K, V> assign(@Nonnull CollisionMap<T, K, V> collisionMap, int hashCode, @Nonnull K hashKey, @Nullable V value, @Nonnull MutableDelta sizeDelta) {
        int thisHashCode = this.hashCode;
        T thisValue = this.value;
        if (hashCode == thisHashCode) {
            T newValue = collisionMap.update(thisValue, hashKey, value, sizeDelta);
            if (newValue == thisValue) {
                return this;
            }
            return new HamtLeafNode<T, K, V>(hashCode, newValue);
        }
        if (Integer.numberOfLeadingZeros(thisHashCode) < Integer.numberOfLeadingZeros(hashCode)) {
            MutableDelta ignored = new MutableDelta();
            SplitableIterator<JImmutableMap.Entry<K, V>> entries = collisionMap.iterator(thisValue);
            HamtNode<Object, K, V> expanded = HamtBranchNode.forLeafExpansion(hashCode, collisionMap.update(null, hashKey, value, sizeDelta));
            while (entries.hasNext()) {
                JImmutableMap.Entry entry = (JImmutableMap.Entry)entries.next();
                expanded = expanded.assign(collisionMap, thisHashCode, entry.getKey(), entry.getValue(), ignored);
            }
            return expanded;
        }
        HamtNode<Object, K, V> expanded = HamtBranchNode.forLeafExpansion(thisHashCode, thisValue);
        return expanded.assign(collisionMap, hashCode, hashKey, value, sizeDelta);
    }

    @Override
    @Nonnull
    public HamtNode<T, K, V> update(@Nonnull CollisionMap<T, K, V> collisionMap, int hashCode, @Nonnull K hashKey, @Nonnull Func1<Holder<V>, V> generator, @Nonnull MutableDelta sizeDelta) {
        int thisHashCode = this.hashCode;
        T thisValue = this.value;
        if (hashCode == thisHashCode) {
            T newValue = collisionMap.update(thisValue, hashKey, generator, sizeDelta);
            if (newValue == thisValue) {
                return this;
            }
            return new HamtLeafNode<T, K, V>(hashCode, newValue);
        }
        if (Integer.numberOfLeadingZeros(thisHashCode) < Integer.numberOfLeadingZeros(hashCode)) {
            MutableDelta ignored = new MutableDelta();
            SplitableIterator<JImmutableMap.Entry<K, V>> entries = collisionMap.iterator(thisValue);
            HamtNode<Object, K, V> expanded = HamtBranchNode.forLeafExpansion(hashCode, collisionMap.update((Object)null, hashKey, generator, sizeDelta));
            while (entries.hasNext()) {
                JImmutableMap.Entry entry = (JImmutableMap.Entry)entries.next();
                expanded = expanded.assign(collisionMap, thisHashCode, entry.getKey(), entry.getValue(), ignored);
            }
            return expanded;
        }
        HamtNode<Object, K, V> expanded = HamtBranchNode.forLeafExpansion(thisHashCode, thisValue);
        return expanded.update(collisionMap, hashCode, hashKey, generator, sizeDelta);
    }

    @Override
    @Nonnull
    public HamtNode<T, K, V> delete(@Nonnull CollisionMap<T, K, V> collisionMap, int hashCode, @Nonnull K hashKey, @Nonnull MutableDelta sizeDelta) {
        int thisHashCode = this.hashCode;
        T thisValue = this.value;
        if (hashCode == this.hashCode) {
            T newValue = collisionMap.delete(thisValue, hashKey, sizeDelta);
            if (newValue == thisValue) {
                return this;
            }
            if (newValue == null) {
                return HamtEmptyNode.of();
            }
            return new HamtLeafNode<T, K, V>(hashCode, newValue);
        }
        return this;
    }

    public HamtNode<T, K, V> liftNode(int index) {
        return new HamtLeafNode<T, K, V>(this.hashCode << 5 | index, this.value);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    @Nonnull
    public SplitableIterator<JImmutableMap.Entry<K, V>> iterator(CollisionMap<T, K, V> collisionMap) {
        return collisionMap.iterator(this.value);
    }

    @Override
    @Nonnull
    public Cursor<JImmutableMap.Entry<K, V>> cursor(CollisionMap<T, K, V> collisionMap) {
        return collisionMap.cursor(this.value);
    }

    @Override
    @Nonnull
    public SplitableIterator<T> iterator() {
        return SingleValueIterator.of(this.value);
    }

    @Override
    @Nonnull
    public Cursor<T> cursor() {
        return SingleValueCursor.of(this.value);
    }
}

