/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.hash.hamt;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.common.MutableDelta;
import org.javimmutable.collections.cursors.StandardCursor;
import org.javimmutable.collections.hash.collision_map.CollisionMap;
import org.javimmutable.collections.hash.hamt.HamtLeafNode;
import org.javimmutable.collections.hash.hamt.HamtNode;
import org.javimmutable.collections.iterators.EmptyIterator;

public class HamtEmptyNode<T, K, V>
implements HamtNode<T, K, V> {
    private static final HamtEmptyNode EMPTY = new HamtEmptyNode();

    public static <T, K, V> HamtNode<T, K, V> of() {
        return EMPTY;
    }

    @Override
    public Holder<V> find(@Nonnull CollisionMap<T, K, V> collisionMap, int hashCode, @Nonnull K hashKey) {
        return Holders.of();
    }

    @Override
    public V getValueOr(@Nonnull CollisionMap<T, K, V> collisionMap, int hashCode, @Nonnull K hashKey, V defaultValue) {
        return defaultValue;
    }

    @Override
    @Nonnull
    public HamtNode<T, K, V> assign(@Nonnull CollisionMap<T, K, V> collisionMap, int hashCode, @Nonnull K hashKey, @Nullable V value, @Nonnull MutableDelta sizeDelta) {
        return new HamtLeafNode(hashCode, collisionMap.update(null, hashKey, value, sizeDelta));
    }

    @Override
    @Nonnull
    public HamtNode<T, K, V> update(@Nonnull CollisionMap<T, K, V> collisionMap, int hashCode, @Nonnull K hashKey, @Nonnull Func1<Holder<V>, V> generator, @Nonnull MutableDelta sizeDelta) {
        return new HamtLeafNode(hashCode, collisionMap.update((Object)null, hashKey, generator, sizeDelta));
    }

    @Override
    @Nonnull
    public HamtNode<T, K, V> delete(@Nonnull CollisionMap<T, K, V> collisionMap, int hashCode, @Nonnull K hashKey, @Nonnull MutableDelta sizeDelta) {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    @Nonnull
    public SplitableIterator<JImmutableMap.Entry<K, V>> iterator(CollisionMap<T, K, V> collisionMap) {
        return EmptyIterator.of();
    }

    @Override
    @Nonnull
    public Cursor<JImmutableMap.Entry<K, V>> cursor(CollisionMap<T, K, V> collisionMap) {
        return StandardCursor.of();
    }

    @Override
    @Nonnull
    public SplitableIterator<T> iterator() {
        return EmptyIterator.of();
    }

    @Override
    @Nonnull
    public Cursor<T> cursor() {
        return StandardCursor.of();
    }
}

