/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.hash.hamt;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Cursorable;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.SplitableIterable;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.common.ArrayHelper;
import org.javimmutable.collections.common.MutableDelta;
import org.javimmutable.collections.cursors.LazyMultiCursor;
import org.javimmutable.collections.cursors.SingleValueCursor;
import org.javimmutable.collections.cursors.StandardCursor;
import org.javimmutable.collections.hash.collision_map.CollisionMap;
import org.javimmutable.collections.hash.hamt.HamtEmptyNode;
import org.javimmutable.collections.hash.hamt.HamtLeafNode;
import org.javimmutable.collections.hash.hamt.HamtNode;
import org.javimmutable.collections.iterators.EmptyIterator;
import org.javimmutable.collections.iterators.LazyMultiIterator;
import org.javimmutable.collections.iterators.SingleValueIterator;

@Immutable
public class HamtBranchNode<T, K, V>
implements ArrayHelper.Allocator<HamtNode<T, K, V>>,
HamtNode<T, K, V> {
    private static final HamtBranchNode[] EMPTY_NODES = new HamtBranchNode[0];
    static final int SHIFT = 5;
    static final int MASK = 31;
    private final int bitmask;
    @Nullable
    private final T value;
    @Nonnull
    private final HamtNode<T, K, V>[] children;

    private HamtBranchNode(int bitmask, @Nullable T value, @Nonnull HamtNode<T, K, V>[] children) {
        this.bitmask = bitmask;
        this.value = value;
        this.children = children;
    }

    static <T, K, V> HamtNode<T, K, V> forLeafExpansion(int hashCode, @Nonnull T value) {
        if (hashCode == 0) {
            return new HamtBranchNode<T, K, V>(0, value, EMPTY_NODES);
        }
        int index = hashCode & 0x1F;
        int remainder = hashCode >>> 5;
        int bit = 1 << index;
        HamtNode[] children = new HamtNode[]{HamtBranchNode.forLeafExpansion(remainder, value)};
        return new HamtBranchNode<Object, K, V>(bit, null, children);
    }

    @Override
    public Holder<V> find(@Nonnull CollisionMap<T, K, V> collisionMap, int hashCode, @Nonnull K hashKey) {
        if (hashCode == 0) {
            if (this.value != null) {
                return collisionMap.findValue(this.value, hashKey);
            }
            return Holders.of();
        }
        int index = hashCode & 0x1F;
        int remainder = hashCode >>> 5;
        int bitmask = this.bitmask;
        int bit = 1 << index;
        if ((bitmask & bit) == 0) {
            return Holders.of();
        }
        int childIndex = HamtBranchNode.realIndex(bitmask, bit);
        return this.children[childIndex].find(collisionMap, remainder, hashKey);
    }

    @Override
    public V getValueOr(@Nonnull CollisionMap<T, K, V> collisionMap, int hashCode, @Nonnull K hashKey, V defaultValue) {
        if (hashCode == 0) {
            if (this.value != null) {
                return collisionMap.getValueOr(this.value, hashKey, defaultValue);
            }
            return defaultValue;
        }
        int index = hashCode & 0x1F;
        int remainder = hashCode >>> 5;
        int bitmask = this.bitmask;
        int bit = 1 << index;
        if ((bitmask & bit) == 0) {
            return defaultValue;
        }
        int childIndex = HamtBranchNode.realIndex(bitmask, bit);
        return this.children[childIndex].getValueOr(collisionMap, remainder, hashKey, defaultValue);
    }

    @Override
    @Nonnull
    public HamtNode<T, K, V> assign(@Nonnull CollisionMap<T, K, V> collisionMap, int hashCode, @Nonnull K hashKey, @Nullable V value, @Nonnull MutableDelta sizeDelta) {
        HamtNode<T, K, V>[] children = this.children;
        int bitmask = this.bitmask;
        T thisValue = this.value;
        if (hashCode == 0) {
            T newValue = collisionMap.update(thisValue, hashKey, value, sizeDelta);
            if (thisValue == newValue) {
                return this;
            }
            return new HamtBranchNode<T, K, V>(bitmask, newValue, children);
        }
        int index = hashCode & 0x1F;
        int remainder = hashCode >>> 5;
        int bit = 1 << index;
        int childIndex = HamtBranchNode.realIndex(bitmask, bit);
        if ((bitmask & bit) == 0) {
            HamtLeafNode newChild = new HamtLeafNode(remainder, collisionMap.update(null, hashKey, value, sizeDelta));
            HamtNode[] newChildren = ArrayHelper.insert(this, children, childIndex, newChild);
            return new HamtBranchNode<T, K, V>(bitmask | bit, thisValue, newChildren);
        }
        HamtNode<Object, K, V> child = children[childIndex];
        HamtNode<T, K, V> newChild = child.assign(collisionMap, remainder, hashKey, value, sizeDelta);
        if (newChild == child) {
            return this;
        }
        HamtNode<T, K, V>[] newChildren = ArrayHelper.assign(children, childIndex, newChild);
        return new HamtBranchNode<T, K, V>(bitmask, thisValue, newChildren);
    }

    @Override
    @Nonnull
    public HamtNode<T, K, V> update(@Nonnull CollisionMap<T, K, V> collisionMap, int hashCode, @Nonnull K hashKey, @Nonnull Func1<Holder<V>, V> generator, @Nonnull MutableDelta sizeDelta) {
        HamtNode<T, K, V>[] children = this.children;
        int bitmask = this.bitmask;
        T thisValue = this.value;
        if (hashCode == 0) {
            T newValue = collisionMap.update(thisValue, hashKey, generator, sizeDelta);
            if (thisValue == newValue) {
                return this;
            }
            return new HamtBranchNode<T, K, V>(bitmask, newValue, children);
        }
        int index = hashCode & 0x1F;
        int remainder = hashCode >>> 5;
        int bit = 1 << index;
        int childIndex = HamtBranchNode.realIndex(bitmask, bit);
        if ((bitmask & bit) == 0) {
            HamtLeafNode newChild = new HamtLeafNode(remainder, collisionMap.update((Object)null, hashKey, generator, sizeDelta));
            HamtNode[] newChildren = ArrayHelper.insert(this, children, childIndex, newChild);
            return new HamtBranchNode<T, K, V>(bitmask | bit, thisValue, newChildren);
        }
        HamtNode<Object, K, V> child = children[childIndex];
        HamtNode<T, K, V> newChild = child.update(collisionMap, remainder, hashKey, generator, sizeDelta);
        if (newChild == child) {
            return this;
        }
        HamtNode<T, K, V>[] newChildren = ArrayHelper.assign(children, childIndex, newChild);
        return new HamtBranchNode<T, K, V>(bitmask, thisValue, newChildren);
    }

    @Override
    @Nonnull
    public HamtNode<T, K, V> delete(@Nonnull CollisionMap<T, K, V> collisionMap, int hashCode, @Nonnull K hashKey, @Nonnull MutableDelta sizeDelta) {
        int bitmask = this.bitmask;
        HamtNode<T, K, V>[] children = this.children;
        T value = this.value;
        if (hashCode == 0) {
            if (value != null) {
                T newValue = collisionMap.delete(value, hashKey, sizeDelta);
                if (newValue == value) {
                    return this;
                }
                if (newValue == null) {
                    if (bitmask == 0) {
                        return HamtEmptyNode.of();
                    }
                    return this.createForDelete(bitmask, null, children);
                }
                return new HamtBranchNode<T, K, V>(bitmask, newValue, children);
            }
            return this;
        }
        int index = hashCode & 0x1F;
        int remainder = hashCode >>> 5;
        int bit = 1 << index;
        int childIndex = HamtBranchNode.realIndex(bitmask, bit);
        if ((bitmask & bit) == 0) {
            return this;
        }
        HamtNode<T, K, V> child = children[childIndex];
        HamtNode<T, K, V> newChild = child.delete(collisionMap, remainder, hashKey, sizeDelta);
        if (newChild == child) {
            return this;
        }
        if (newChild.isEmpty()) {
            if (children.length == 1) {
                if (value == null) {
                    return HamtEmptyNode.of();
                }
                return new HamtLeafNode(0, value);
            }
            HamtNode<T, K, V>[] newChildren = ArrayHelper.delete(this, children, childIndex);
            return this.createForDelete(bitmask & ~bit, value, newChildren);
        }
        HamtNode<T, K, V>[] newChildren = ArrayHelper.assign(children, childIndex, newChild);
        return this.createForDelete(bitmask, value, newChildren);
    }

    private HamtNode<T, K, V> createForDelete(int bitmask, T value, @Nonnull HamtNode<T, K, V>[] children) {
        if (value == null && children.length == 1) {
            HamtNode<T, K, V> child = children[0];
            if (child instanceof HamtLeafNode) {
                HamtLeafNode leaf = (HamtLeafNode)child;
                return leaf.liftNode(Integer.numberOfTrailingZeros(bitmask));
            }
            if (child instanceof HamtBranchNode) {
                HamtBranchNode branch = (HamtBranchNode)child;
                if (branch.value != null && branch.children.length == 0) {
                    return new HamtLeafNode(Integer.numberOfTrailingZeros(bitmask), branch.value);
                }
            }
        }
        return new HamtBranchNode<T, K, V>(bitmask, value, children);
    }

    @Override
    public boolean isEmpty() {
        return this.bitmask == 0 && this.value == null;
    }

    private static int realIndex(int bitmask, int bit) {
        return Integer.bitCount(bitmask & bit - 1);
    }

    @Nonnull
    public HamtNode<T, K, V>[] allocate(int size) {
        return new HamtNode[size];
    }

    @Override
    @Nonnull
    public SplitableIterator<JImmutableMap.Entry<K, V>> iterator(CollisionMap<T, K, V> collisionMap) {
        return LazyMultiIterator.transformed(this.indexedForIterator(), node -> () -> this.iteratorHelper((SplitableIterator<T>)node.iterator(), collisionMap));
    }

    @Nonnull
    private SplitableIterator<JImmutableMap.Entry<K, V>> iteratorHelper(SplitableIterator<T> value, CollisionMap<T, K, V> collisionMap) {
        return LazyMultiIterator.transformed(value, t -> () -> collisionMap.iterator(t));
    }

    @Override
    @Nonnull
    public SplitableIterator<T> iterator() {
        return LazyMultiIterator.iterator(this.indexedForIterator());
    }

    @Override
    @Nonnull
    public Cursor<JImmutableMap.Entry<K, V>> cursor(CollisionMap<T, K, V> collisionMap) {
        return LazyMultiCursor.transformed(this.indexedForCursor(), node -> () -> this.cursorHelper(node.cursor(), collisionMap));
    }

    @Nonnull
    private Cursor<JImmutableMap.Entry<K, V>> cursorHelper(Cursor<T> value, CollisionMap<T, K, V> collisionMap) {
        return LazyMultiCursor.transformed(value, t -> () -> collisionMap.cursor(t));
    }

    @Override
    @Nonnull
    public Cursor<T> cursor() {
        return LazyMultiCursor.cursor(this.indexedForCursor());
    }

    public String toString() {
        return "(" + this.value + ",0x" + Integer.toHexString(this.bitmask) + "," + this.children.length + ")";
    }

    @Override
    public void checkInvariants() {
        if (this.value == null && this.children.length == 1 && this.children[0] instanceof HamtLeafNode) {
            throw new IllegalStateException();
        }
        for (HamtNode<T, K, V> child : this.children) {
            child.checkInvariants();
        }
    }

    private Indexed<SplitableIterable<T>> indexedForIterator() {
        return new Indexed<SplitableIterable<T>>(){

            @Override
            public SplitableIterable<T> get(int index) {
                if (index == 0) {
                    if (HamtBranchNode.this.value != null) {
                        return () -> SingleValueIterator.of(HamtBranchNode.this.value);
                    }
                    return () -> EmptyIterator.of();
                }
                return HamtBranchNode.this.children[index - 1];
            }

            @Override
            public int size() {
                return HamtBranchNode.this.children.length + 1;
            }
        };
    }

    private Indexed<Cursorable<T>> indexedForCursor() {
        return new Indexed<Cursorable<T>>(){

            @Override
            public Cursorable<T> get(int index) {
                if (index == 0) {
                    if (HamtBranchNode.this.value != null) {
                        return () -> SingleValueCursor.of(HamtBranchNode.this.value);
                    }
                    return () -> StandardCursor.of();
                }
                return HamtBranchNode.this.children[index - 1];
            }

            @Override
            public int size() {
                return HamtBranchNode.this.children.length + 1;
            }
        };
    }
}

