/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.hash.collision_map;

import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.common.MutableDelta;
import org.javimmutable.collections.hash.collision_map.CollisionMap;
import org.javimmutable.collections.tree.BranchNode;
import org.javimmutable.collections.tree.ComparableComparator;
import org.javimmutable.collections.tree.LeafNode;
import org.javimmutable.collections.tree.Node;
import org.javimmutable.collections.tree.UpdateResult;

@Immutable
public class TreeCollisionMap<K extends Comparable<K>, V>
implements CollisionMap<Node<K, V>, K, V> {
    private final Comparator<K> comparator = ComparableComparator.of();

    @Override
    @Nonnull
    public Node<K, V> update(Node<K, V> leaf, @Nonnull K key, V value, @Nonnull MutableDelta delta) {
        if (leaf == null) {
            delta.add(1);
            return new LeafNode<K, V>(key, value);
        }
        return this.resultForUpdate(leaf, delta, leaf.assign(this.comparator, key, value));
    }

    @Override
    @Nonnull
    public Node<K, V> update(@Nullable Node<K, V> leaf, @Nonnull K key, @Nonnull Func1<Holder<V>, V> generator, @Nonnull MutableDelta delta) {
        if (leaf == null) {
            delta.add(1);
            return new LeafNode<K, V>(key, generator.apply(Holders.of()));
        }
        return this.resultForUpdate(leaf, delta, leaf.update(this.comparator, key, generator));
    }

    @Override
    public Node<K, V> delete(@Nonnull Node<K, V> leaf, @Nonnull K key, @Nonnull MutableDelta delta) {
        Node<K, V> newLeaf = leaf.delete(this.comparator, key);
        if (newLeaf == leaf) {
            return leaf;
        }
        delta.add(-1);
        return newLeaf.isEmpty() ? null : newLeaf.compress();
    }

    @Override
    public V getValueOr(@Nonnull Node<K, V> leaf, @Nonnull K key, V defaultValue) {
        return leaf.getValueOr(this.comparator, key, defaultValue);
    }

    @Override
    public Holder<V> findValue(@Nonnull Node<K, V> leaf, @Nonnull K key) {
        return leaf.find(this.comparator, key);
    }

    @Override
    public Holder<JImmutableMap.Entry<K, V>> findEntry(@Nonnull Node<K, V> leaf, @Nonnull K key) {
        return leaf.findEntry(this.comparator, key);
    }

    @Override
    public Cursor<JImmutableMap.Entry<K, V>> cursor(@Nonnull Node<K, V> leaf) {
        return leaf.cursor();
    }

    @Override
    public SplitableIterator<JImmutableMap.Entry<K, V>> iterator(@Nonnull Node<K, V> leaf) {
        return leaf.iterator();
    }

    private Node<K, V> resultForUpdate(Node<K, V> leaf, @Nonnull MutableDelta delta, UpdateResult<K, V> result) {
        switch (result.type) {
            case UNCHANGED: {
                return leaf;
            }
            case INPLACE: {
                delta.add(result.sizeDelta);
                return result.newNode;
            }
            case SPLIT: {
                delta.add(result.sizeDelta);
                return new BranchNode(result.newNode, result.extraNode);
            }
        }
        throw new IllegalStateException("unknown UpdateResult.Type value");
    }
}

