/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.hash.collision_map;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.common.MutableDelta;
import org.javimmutable.collections.cursors.SingleValueCursor;
import org.javimmutable.collections.hash.collision_map.ListNode;
import org.javimmutable.collections.hash.collision_map.MultiValueListNode;
import org.javimmutable.collections.iterators.SingleValueIterator;

@Immutable
public class SingleValueListNode<K, V>
implements ListNode<K, V>,
JImmutableMap.Entry<K, V>,
Holders.Filled<V> {
    private final K key;
    private final V value;

    private SingleValueListNode(K key, V value) {
        this.key = key;
        this.value = value;
    }

    static <K, V> SingleValueListNode<K, V> of(K key, V value) {
        return new SingleValueListNode<K, V>(key, value);
    }

    @Override
    public V getValueForKey(K key, V defaultValue) {
        return this.key.equals(key) ? this.value : defaultValue;
    }

    @Override
    public Holder<V> findValueForKey(K key) {
        return this.key.equals(key) ? this : Holders.of();
    }

    @Override
    public JImmutableMap.Entry<K, V> getEntryForKey(K key) {
        return this.key.equals(key) ? this : null;
    }

    @Override
    public ListNode<K, V> setValueForKey(K key, V value, MutableDelta sizeDelta) {
        if (key.equals(this.key)) {
            return this.value == value ? this : new SingleValueListNode<K, V>(key, value);
        }
        sizeDelta.add(1);
        return MultiValueListNode.of(this, new SingleValueListNode<K, V>(key, value));
    }

    @Override
    public ListNode<K, V> setValueForKey(K key, Func1<Holder<V>, V> generator, MutableDelta sizeDelta) {
        if (key.equals(this.key)) {
            V value = generator.apply(this);
            return this.value == value ? this : new SingleValueListNode<K, V>(key, value);
        }
        sizeDelta.add(1);
        return MultiValueListNode.of(this, new SingleValueListNode<K, V>(key, generator.apply(Holders.of())));
    }

    @Override
    public ListNode<K, V> deleteValueForKey(K key, MutableDelta sizeDelta) {
        if (this.key.equals(key)) {
            sizeDelta.subtract(1);
            return null;
        }
        return this;
    }

    @Override
    @Nonnull
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    @Nonnull
    public Cursor<JImmutableMap.Entry<K, V>> cursor() {
        return SingleValueCursor.of(this);
    }

    @Override
    @Nonnull
    public SplitableIterator<JImmutableMap.Entry<K, V>> iterator() {
        return SingleValueIterator.of(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleValueListNode that = (SingleValueListNode)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SingleValueLeafNode{key=" + this.key + ", value=" + this.value + '}';
    }
}

