/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.hash.collision_map;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.Sequence;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.common.EmptySequence;
import org.javimmutable.collections.common.MutableDelta;
import org.javimmutable.collections.cursors.SequenceCursor;
import org.javimmutable.collections.hash.collision_map.ListNode;
import org.javimmutable.collections.hash.collision_map.SingleValueListNode;
import org.javimmutable.collections.iterators.SequenceIterator;

@Immutable
public class MultiValueListNode<K, V>
implements ListNode<K, V>,
Sequence<JImmutableMap.Entry<K, V>> {
    private final MultiValueListNode<K, V> next;
    private final SingleValueListNode<K, V> entry;

    private MultiValueListNode(MultiValueListNode<K, V> next, SingleValueListNode<K, V> entry) {
        this.next = next;
        this.entry = entry;
    }

    static <K, V> MultiValueListNode<K, V> of(K key, V value) {
        return new MultiValueListNode<K, V>(null, SingleValueListNode.of(key, value));
    }

    static <K, V> MultiValueListNode<K, V> of(SingleValueListNode<K, V> entry1, SingleValueListNode<K, V> entry2) {
        return new MultiValueListNode<K, V>(new MultiValueListNode<K, V>(null, entry1), entry2);
    }

    static <K, V> MultiValueListNode<K, V> of(SingleValueListNode<K, V> entry1, SingleValueListNode<K, V> entry2, SingleValueListNode<K, V> entry3) {
        return new MultiValueListNode<K, V>(new MultiValueListNode<K, V>(new MultiValueListNode<K, V>(null, entry1), entry2), entry3);
    }

    @Override
    public V getValueForKey(K key, V defaultValue) {
        SingleValueListNode<K, V> answer = this.getEntryForKeyImpl(key);
        if (answer != null) {
            return answer.getValue();
        }
        return defaultValue;
    }

    @Override
    public Holder<V> findValueForKey(K key) {
        SingleValueListNode<K, V> answer = this.getEntryForKeyImpl(key);
        if (answer != null) {
            return answer;
        }
        return Holders.of();
    }

    @Override
    public JImmutableMap.Entry<K, V> getEntryForKey(K key) {
        return this.getEntryForKeyImpl(key);
    }

    @Override
    public MultiValueListNode<K, V> setValueForKey(K key, V value, MutableDelta sizeDelta) {
        SingleValueListNode<K, V> entry = this.getEntryForKeyImpl(key);
        if (entry == null) {
            sizeDelta.add(1);
            return new MultiValueListNode<K, V>(this, SingleValueListNode.of(key, value));
        }
        if (entry.getValue() == value) {
            return this;
        }
        return new MultiValueListNode<K, V>(this.removeKeyFromList(key), SingleValueListNode.of(key, value));
    }

    @Override
    public ListNode<K, V> setValueForKey(K key, Func1<Holder<V>, V> generator, MutableDelta sizeDelta) {
        SingleValueListNode<K, V> entry = this.getEntryForKeyImpl(key);
        if (entry == null) {
            sizeDelta.add(1);
            return new MultiValueListNode<K, V>(this, SingleValueListNode.of(key, generator.apply(Holders.of())));
        }
        V value = generator.apply(entry);
        if (entry.getValue() == value) {
            return this;
        }
        return new MultiValueListNode<K, V>(this.removeKeyFromList(key), SingleValueListNode.of(key, value));
    }

    @Override
    public ListNode<K, V> deleteValueForKey(K key, MutableDelta sizeDelta) {
        if (this.getEntryForKey(key) == null) {
            return this;
        }
        MultiValueListNode<K, V> newList = this.removeKeyFromList(key);
        sizeDelta.subtract(1);
        return newList != null && newList.next == null ? newList.entry : newList;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public JImmutableMap.Entry<K, V> getHead() {
        return this.entry;
    }

    @Override
    @Nonnull
    public Sequence<JImmutableMap.Entry<K, V>> getTail() {
        if (this.next == null) {
            return EmptySequence.of();
        }
        return this.next;
    }

    @Override
    @Nonnull
    public Cursor<JImmutableMap.Entry<K, V>> cursor() {
        return SequenceCursor.of(this);
    }

    @Override
    @Nonnull
    public SplitableIterator<JImmutableMap.Entry<K, V>> iterator() {
        return SequenceIterator.iterator(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiValueListNode that = (MultiValueListNode)o;
        if (this.entry != null ? !this.entry.equals(that.entry) : that.entry != null) {
            return false;
        }
        return !(this.next != null ? !this.next.equals(that.next) : that.next != null);
    }

    public int hashCode() {
        int result = this.next != null ? this.next.hashCode() : 0;
        result = 31 * result + (this.entry != null ? this.entry.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MultiValueLeafNode{next=" + this.next + ", entry=" + this.entry + '}';
    }

    private MultiValueListNode<K, V> removeKeyFromList(K key) {
        MultiValueListNode<K, V> newList = null;
        MultiValueListNode<K, V> node = this;
        while (node != null) {
            if (!node.keyEquals(key)) {
                newList = new MultiValueListNode<K, V>(newList, node.entry);
            }
            node = node.next;
        }
        return newList;
    }

    private SingleValueListNode<K, V> getEntryForKeyImpl(K key) {
        MultiValueListNode<K, V> node = this;
        while (node != null) {
            if (node.keyEquals(key)) {
                return node.entry;
            }
            node = node.next;
        }
        return null;
    }

    private boolean keyEquals(K key) {
        return key.equals(this.entry.getKey());
    }
}

