/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.hash.collision_map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.common.MutableDelta;
import org.javimmutable.collections.hash.collision_map.CollisionMap;
import org.javimmutable.collections.hash.collision_map.ListNode;
import org.javimmutable.collections.hash.collision_map.SingleValueListNode;

@Immutable
public class ListCollisionMap<K, V>
implements CollisionMap<ListNode<K, V>, K, V> {
    @Override
    @Nonnull
    public ListNode<K, V> update(ListNode<K, V> leaf, @Nonnull K key, V value, @Nonnull MutableDelta delta) {
        if (leaf == null) {
            delta.add(1);
            return SingleValueListNode.of(key, value);
        }
        return leaf.setValueForKey(key, value, delta);
    }

    @Override
    @Nonnull
    public ListNode<K, V> update(@Nullable ListNode<K, V> leaf, @Nonnull K key, @Nonnull Func1<Holder<V>, V> generator, @Nonnull MutableDelta delta) {
        if (leaf == null) {
            delta.add(1);
            return SingleValueListNode.of(key, generator.apply(Holders.of()));
        }
        return leaf.setValueForKey(key, generator, delta);
    }

    @Override
    public ListNode<K, V> delete(@Nonnull ListNode<K, V> leaf, @Nonnull K key, @Nonnull MutableDelta delta) {
        return leaf.deleteValueForKey(key, delta);
    }

    @Override
    public V getValueOr(@Nonnull ListNode<K, V> leaf, @Nonnull K key, V defaultValue) {
        return leaf.getValueForKey(key, defaultValue);
    }

    @Override
    public Holder<V> findValue(@Nonnull ListNode<K, V> leaf, @Nonnull K key) {
        return leaf.findValueForKey(key);
    }

    @Override
    public Holder<JImmutableMap.Entry<K, V>> findEntry(@Nonnull ListNode<K, V> leaf, @Nonnull K key) {
        return Holders.fromNullable(leaf.getEntryForKey(key));
    }

    @Override
    public Cursor<JImmutableMap.Entry<K, V>> cursor(@Nonnull ListNode<K, V> leaf) {
        return leaf.cursor();
    }

    @Override
    public SplitableIterator<JImmutableMap.Entry<K, V>> iterator(@Nonnull ListNode<K, V> leaf) {
        return leaf.iterator();
    }
}

