/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.hash;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.MapEntry;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.common.AbstractJImmutableMap;
import org.javimmutable.collections.common.MutableDelta;
import org.javimmutable.collections.hash.EmptyHashMap;
import org.javimmutable.collections.hash.collision_map.CollisionMap;
import org.javimmutable.collections.hash.collision_map.ListCollisionMap;
import org.javimmutable.collections.hash.collision_map.TreeCollisionMap;
import org.javimmutable.collections.hash.hamt.HamtEmptyNode;
import org.javimmutable.collections.hash.hamt.HamtNode;
import org.javimmutable.collections.serialization.JImmutableHashMapProxy;

@Immutable
public class JImmutableHashMap<T, K, V>
extends AbstractJImmutableMap<K, V>
implements Serializable {
    static final ListCollisionMap LIST_COLLISION_MAP = new ListCollisionMap();
    static final TreeCollisionMap TREE_COLLISION_MAP = new TreeCollisionMap();
    static final JImmutableHashMap LIST_EMPTY = new JImmutableHashMap(HamtEmptyNode.of(), 0, LIST_COLLISION_MAP);
    static final JImmutableHashMap TREE_EMPTY = new JImmutableHashMap(HamtEmptyNode.of(), 0, TREE_COLLISION_MAP);
    private static final long serialVersionUID = -121805L;
    private final HamtNode<T, K, V> root;
    private final int size;
    private final CollisionMap<T, K, V> collisionMap;

    private JImmutableHashMap(HamtNode<T, K, V> root, int size, CollisionMap<T, K, V> collisionMap) {
        this.root = root;
        this.size = size;
        this.collisionMap = collisionMap;
    }

    public static <K, V> EmptyHashMap<K, V> of() {
        return EmptyHashMap.INSTANCE;
    }

    public static <K, V> JImmutableMap<K, V> of(Class<K> klass) {
        return klass.isAssignableFrom(Comparable.class) ? TREE_EMPTY : LIST_EMPTY;
    }

    public static <K, V> JImmutableMap<K, V> forKey(K key) {
        return key instanceof Comparable ? TREE_EMPTY : LIST_EMPTY;
    }

    public static <K, V> JImmutableMap<K, V> usingList() {
        return LIST_EMPTY;
    }

    public static <K extends Comparable<K>, V> JImmutableMap<K, V> usingTree() {
        return TREE_EMPTY;
    }

    @Override
    public V getValueOr(K key, V defaultValue) {
        return this.root.getValueOr(this.collisionMap, key.hashCode(), key, defaultValue);
    }

    @Override
    @Nonnull
    public Holder<V> find(@Nonnull K key) {
        return this.root.find(this.collisionMap, key.hashCode(), key);
    }

    @Override
    @Nonnull
    public Holder<JImmutableMap.Entry<K, V>> findEntry(@Nonnull K key) {
        Holder<V> value = this.find(key);
        if (value.isEmpty()) {
            return Holders.of();
        }
        return Holders.of(MapEntry.of(key, value.getValue()));
    }

    @Override
    @Nonnull
    public JImmutableMap<K, V> assign(@Nonnull K key, V value) {
        MutableDelta sizeDelta = new MutableDelta();
        HamtNode<T, K, V> newRoot = this.root.assign(this.collisionMap, key.hashCode(), key, value, sizeDelta);
        if (newRoot == this.root) {
            return this;
        }
        return new JImmutableHashMap<T, K, V>(newRoot, this.size + sizeDelta.getValue(), this.collisionMap);
    }

    @Override
    @Nonnull
    public JImmutableMap<K, V> update(@Nonnull K key, @Nonnull Func1<Holder<V>, V> generator) {
        MutableDelta sizeDelta = new MutableDelta();
        HamtNode<T, K, V> newRoot = this.root.update(this.collisionMap, key.hashCode(), key, generator, sizeDelta);
        if (newRoot == this.root) {
            return this;
        }
        return new JImmutableHashMap<T, K, V>(newRoot, this.size + sizeDelta.getValue(), this.collisionMap);
    }

    @Override
    @Nonnull
    public JImmutableMap<K, V> delete(@Nonnull K key) {
        MutableDelta sizeDelta = new MutableDelta();
        HamtNode<T, K, V> newRoot = this.root.delete(this.collisionMap, key.hashCode(), key, sizeDelta);
        if (newRoot == this.root) {
            return this;
        }
        if (newRoot.isEmpty()) {
            return JImmutableHashMap.of();
        }
        return new JImmutableHashMap<T, K, V>(newRoot, this.size + sizeDelta.getValue(), this.collisionMap);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    @Nonnull
    public JImmutableMap<K, V> deleteAll() {
        return JImmutableHashMap.of();
    }

    @Override
    @Nonnull
    public Cursor<JImmutableMap.Entry<K, V>> cursor() {
        return this.root.cursor(this.collisionMap);
    }

    @Override
    @Nonnull
    public SplitableIterator<JImmutableMap.Entry<K, V>> iterator() {
        return this.root.iterator(this.collisionMap);
    }

    @Override
    public void checkInvariants() {
        this.root.checkInvariants();
    }

    CollisionMap getCollisionMap() {
        return this.collisionMap;
    }

    private Object writeReplace() {
        return new JImmutableHashMapProxy(this);
    }
}

