/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.hash;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.common.AbstractJImmutableMap;
import org.javimmutable.collections.cursors.StandardCursor;
import org.javimmutable.collections.hash.JImmutableHashMap;
import org.javimmutable.collections.iterators.EmptyIterator;
import org.javimmutable.collections.serialization.JImmutableHashMapProxy;

@Immutable
public class EmptyHashMap<K, V>
extends AbstractJImmutableMap<K, V>
implements Serializable {
    static final EmptyHashMap INSTANCE = new EmptyHashMap();
    private static final long serialVersionUID = -121805L;

    private EmptyHashMap() {
    }

    @Override
    @Nonnull
    public Holder<V> find(@Nonnull K key) {
        return Holders.of();
    }

    @Override
    @Nonnull
    public Holder<JImmutableMap.Entry<K, V>> findEntry(@Nonnull K key) {
        return Holders.of();
    }

    @Override
    @Nonnull
    public JImmutableMap<K, V> assign(@Nonnull K key, V value) {
        return JImmutableHashMap.forKey(key).assign(key, value);
    }

    @Override
    @Nonnull
    public JImmutableMap<K, V> delete(@Nonnull K key) {
        return this;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    @Nonnull
    public JImmutableMap<K, V> deleteAll() {
        return this;
    }

    @Override
    @Nonnull
    public Cursor<JImmutableMap.Entry<K, V>> cursor() {
        return StandardCursor.of();
    }

    @Override
    @Nonnull
    public SplitableIterator<JImmutableMap.Entry<K, V>> iterator() {
        return EmptyIterator.of();
    }

    @Override
    public int getSpliteratorCharacteristics() {
        return 1024;
    }

    @Override
    public V getValueOr(K key, V defaultValue) {
        return defaultValue;
    }

    @Override
    public void checkInvariants() {
    }

    private Object writeReplace() {
        return new JImmutableHashMapProxy(this);
    }
}

