/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.cursors;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Tuple2;
import org.javimmutable.collections.cursors.AbstractStartCursor;
import org.javimmutable.collections.cursors.AbstractStartedCursor;
import org.javimmutable.collections.cursors.EmptyStartedCursor;

@Immutable
public final class ZipCursor {
    private ZipCursor() {
    }

    public static <C1, C2> Cursor<Tuple2<C1, C2>> of(final Cursor<C1> cursor1, final Cursor<C2> cursor2) {
        return new AbstractStartCursor<Tuple2<C1, C2>>(){

            @Override
            @Nonnull
            public Cursor<Tuple2<C1, C2>> next() {
                return ZipCursor.next(cursor1.next(), cursor2.next());
            }
        };
    }

    private static <C1, C2> Cursor<Tuple2<C1, C2>> next(final Cursor<C1> cursor1, final Cursor<C2> cursor2) {
        if (!cursor1.hasValue() || !cursor2.hasValue()) {
            return EmptyStartedCursor.of();
        }
        return new AbstractStartedCursor<Tuple2<C1, C2>>(){

            @Override
            @Nonnull
            public Cursor<Tuple2<C1, C2>> next() {
                return ZipCursor.next(cursor1.next(), cursor2.next());
            }

            @Override
            public Tuple2<C1, C2> getValue() {
                return new Tuple2(cursor1.getValue(), cursor2.getValue());
            }
        };
    }
}

