/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.cursors;

import javax.annotation.Nonnull;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.cursors.AbstractStartCursor;
import org.javimmutable.collections.cursors.AbstractStartedCursor;
import org.javimmutable.collections.cursors.ValueFunction;
import org.javimmutable.collections.cursors.ValueFunctionFactory;

public abstract class ValueFunctionCursor {
    public static <T, F extends ValueFunction<T>, A extends ValueFunctionFactory<T, F>> Cursor<T> of(A factory) {
        return new Start(factory);
    }

    private static class Started<T, F extends ValueFunction<T>>
    extends AbstractStartedCursor<T> {
        private final F function;
        private Cursor<T> next;
        private final T value;

        private Started(F function, T value) {
            this.function = function;
            this.value = value;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        @Nonnull
        public Cursor<T> next() {
            if (this.next == null) {
                Holder nextValue = this.function.nextValue();
                this.next = nextValue.isFilled() ? new Started(this.function, nextValue.getValue()) : super.next();
            }
            return this.next;
        }

        /* synthetic */ Started(ValueFunction x0, Object x1, 1 x2) {
            this(x0, x1);
        }
    }

    protected static class Start<T, F extends ValueFunction<T>, A extends ValueFunctionFactory<T, F>>
    extends AbstractStartCursor<T> {
        private final A factory;

        protected Start(A factory) {
            this.factory = factory;
        }

        @Override
        @Nonnull
        public Cursor<T> next() {
            F function = this.createFunction();
            Holder firstValue = function.nextValue();
            return firstValue.isFilled() ? new Started((ValueFunction)function, firstValue.getValue(), null) : super.next();
        }

        protected F createFunction() {
            return this.factory.createFunction();
        }
    }
}

