/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.cursors;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.SplitCursor;
import org.javimmutable.collections.cursors.AbstractCursor;

@Immutable
public class TransformCursor<S, T>
extends AbstractCursor<T> {
    private final Cursor<S> source;
    private final Func1<S, T> transforminator;

    public TransformCursor(Cursor<S> source, Func1<S, T> transforminator) {
        this.source = source;
        this.transforminator = transforminator;
    }

    public static <S, T> Cursor<T> of(Cursor<S> cursor, Func1<S, T> transforminator) {
        return new TransformCursor<S, T>(cursor, transforminator);
    }

    public static <K, V> Cursor<K> ofKeys(Cursor<JImmutableMap.Entry<K, V>> cursor) {
        return new TransformCursor<JImmutableMap.Entry, Object>(cursor, entry -> entry.getKey());
    }

    public static <K, V> Cursor<V> ofValues(Cursor<JImmutableMap.Entry<K, V>> cursor) {
        return new TransformCursor<JImmutableMap.Entry, Object>(cursor, entry -> entry.getValue());
    }

    @Override
    @Nonnull
    public Cursor<T> start() {
        return new TransformCursor<S, T>(this.source.start(), this.transforminator);
    }

    @Override
    @Nonnull
    public Cursor<T> next() {
        return new TransformCursor<S, T>(this.source.next(), this.transforminator);
    }

    @Override
    public boolean hasValue() {
        return this.source.hasValue();
    }

    @Override
    public T getValue() {
        return this.transforminator.apply(this.source.getValue());
    }

    @Override
    public boolean isSplitAllowed() {
        return this.source.isSplitAllowed();
    }

    @Override
    public SplitCursor<T> splitCursor() {
        SplitCursor<S> split = this.source.splitCursor();
        return new SplitCursor<T>(TransformCursor.of(split.getLeft(), this.transforminator), TransformCursor.of(split.getRight(), this.transforminator));
    }
}

