/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.cursors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Cursorable;
import org.javimmutable.collections.Func0;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.SplitCursor;
import org.javimmutable.collections.Tuple2;
import org.javimmutable.collections.cursors.AbstractStartCursor;
import org.javimmutable.collections.cursors.AbstractStartedCursor;

@Immutable
public abstract class StandardCursor {
    private static final Cursor EMPTY = new Start(new EmptySource());

    public static <T> Cursor<T> of() {
        return EMPTY;
    }

    public static <T> Cursor<T> of(Func0<Source<T>> sourceFactory) {
        return new FactoryStart(sourceFactory);
    }

    public static <T> Cursor<T> of(Source<T> source) {
        return source.atEnd() ? StandardCursor.of() : new Start(source);
    }

    public static <T> Cursor<T> of(Indexed<T> source) {
        return new Start(new IndexedSource(source, 0, source.size()));
    }

    public static <T> Iterator<T> iterator(Source<T> source) {
        return new SourceIterator(source);
    }

    public static Cursor<Integer> forRange(int low, int high) {
        return StandardCursor.of(new RangeSource(low, high));
    }

    public static <T> Cursor<T> repeating(int count, T value) {
        return StandardCursor.of(new RepeatingValueCursorSource(count, value));
    }

    public static <T> List<T> makeList(Cursor<T> cursor) {
        ArrayList<T> answer = new ArrayList<T>();
        cursor = cursor.start();
        while (cursor.hasValue()) {
            answer.add(cursor.getValue());
            cursor = cursor.next();
        }
        return answer;
    }

    public static <T> List<T> makeList(Iterator<T> iterator) {
        ArrayList<T> answer = new ArrayList<T>();
        while (iterator.hasNext()) {
            answer.add(iterator.next());
        }
        return answer;
    }

    public static <T> Cursorable<T> emptyCursorable() {
        return new Cursorable<T>(){

            @Override
            @Nonnull
            public Cursor<T> cursor() {
                return StandardCursor.of();
            }
        };
    }

    public static <T> Source<T> emptySource() {
        return new EmptySource();
    }

    @Immutable
    private static class IndexedSource<T>
    implements Source<T> {
        private final Indexed<T> list;
        private final int index;
        private final int limit;

        private IndexedSource(Indexed<T> list, int index, int limit) {
            this.list = list;
            this.index = index;
            this.limit = limit;
        }

        @Override
        public boolean atEnd() {
            return this.index >= this.limit;
        }

        @Override
        public T currentValue() {
            return this.list.get(this.index);
        }

        @Override
        public Source<T> advance() {
            return new IndexedSource<T>(this.list, this.index + 1, this.limit);
        }

        @Override
        public boolean isSplitAllowed() {
            return this.limit - this.index > 1;
        }

        @Override
        public Tuple2<Source<T>, Source<T>> splitSource() {
            int splitIndex = this.index + (this.limit - this.index) / 2;
            if (splitIndex == this.index) {
                throw new UnsupportedOperationException();
            }
            return Tuple2.of(new IndexedSource<T>(this.list, this.index, splitIndex), new IndexedSource<T>(this.list, splitIndex, this.limit));
        }
    }

    private static class SourceIterator<T>
    implements Iterator<T> {
        private Source<T> source;

        private SourceIterator(Source<T> source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            return !this.source.atEnd();
        }

        @Override
        public T next() {
            if (this.source.atEnd()) {
                throw new NoSuchElementException();
            }
            T value = this.source.currentValue();
            this.source = this.source.advance();
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    @Immutable
    private static class RepeatingValueCursorSource<T>
    implements Source<T> {
        private int count;
        private final T value;

        private RepeatingValueCursorSource(int count, T value) {
            this.count = count;
            this.value = value;
        }

        @Override
        public boolean atEnd() {
            return this.count <= 0;
        }

        @Override
        public T currentValue() {
            return this.value;
        }

        @Override
        public Source<T> advance() {
            return new RepeatingValueCursorSource<T>(this.count - 1, this.value);
        }

        @Override
        public boolean isSplitAllowed() {
            return this.count >= 2;
        }

        @Override
        public Tuple2<Source<T>, Source<T>> splitSource() {
            if (this.count < 2) {
                throw new UnsupportedOperationException();
            }
            int left = this.count / 2;
            int right = this.count - left;
            return Tuple2.of(new RepeatingValueCursorSource<T>(left, this.value), new RepeatingValueCursorSource<T>(right, this.value));
        }
    }

    @Immutable
    static class RangeSource
    implements Source<Integer> {
        private final int low;
        private final int high;

        RangeSource(int low, int high) {
            this.low = low;
            this.high = high;
        }

        @Override
        public boolean atEnd() {
            return this.low > this.high;
        }

        @Override
        public Integer currentValue() {
            return this.low;
        }

        @Override
        public Source<Integer> advance() {
            return new RangeSource(this.low + 1, this.high);
        }

        @Override
        public boolean isSplitAllowed() {
            return this.high > this.low;
        }

        @Override
        public Tuple2<Source<Integer>, Source<Integer>> splitSource() {
            if (this.low >= this.high) {
                throw new UnsupportedOperationException();
            }
            int middle = this.low + 1 + (this.high - this.low) / 2;
            return Tuple2.of(new RangeSource(this.low, middle - 1), new RangeSource(middle, this.high));
        }
    }

    @Immutable
    private static class EmptySource<T>
    implements Source<T> {
        private EmptySource() {
        }

        @Override
        public boolean atEnd() {
            return true;
        }

        @Override
        public T currentValue() {
            throw new Cursor.NoValueException();
        }

        @Override
        public Source<T> advance() {
            throw new IllegalStateException();
        }
    }

    @Immutable
    private static class Started<T>
    extends AbstractStartedCursor<T> {
        private final Source<T> source;

        private Started(Source<T> source) {
            this.source = source;
        }

        @Override
        @Nonnull
        public Cursor<T> next() {
            return this.source.atEnd() ? super.next() : new Started<T>(this.source.advance());
        }

        @Override
        public boolean hasValue() {
            return !this.source.atEnd();
        }

        @Override
        public T getValue() {
            if (this.source.atEnd()) {
                throw new Cursor.NoValueException();
            }
            return this.source.currentValue();
        }

        @Override
        public boolean isSplitAllowed() {
            return this.source.isSplitAllowed();
        }

        @Override
        public SplitCursor<T> splitCursor() {
            Tuple2<Source<T>, Source<T>> split = this.source.splitSource();
            return new SplitCursor<T>(StandardCursor.of(split.getFirst()), StandardCursor.of(split.getSecond()));
        }
    }

    @Immutable
    private static class FactoryStart<T>
    extends AbstractStartCursor<T> {
        private final Func0<Source<T>> factory;

        private FactoryStart(Func0<Source<T>> factory) {
            this.factory = factory;
        }

        @Override
        @Nonnull
        public Cursor<T> next() {
            return new Started(this.factory.apply());
        }
    }

    @Immutable
    private static class Start<T>
    extends AbstractStartCursor<T> {
        private final Source<T> source;

        private Start(Source<T> source) {
            this.source = source;
        }

        @Override
        @Nonnull
        public Cursor<T> next() {
            return new Started(this.source);
        }
    }

    public static interface Source<T> {
        public boolean atEnd();

        public T currentValue();

        public Source<T> advance();

        default public boolean isSplitAllowed() {
            return false;
        }

        default public Tuple2<Source<T>, Source<T>> splitSource() {
            throw new UnsupportedOperationException();
        }
    }
}

