/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.cursors;

import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Sequence;
import org.javimmutable.collections.cursors.StandardCursor;

@Immutable
public class SequenceCursor<T> {
    private SequenceCursor() {
    }

    public static <T> Cursor<T> of(Sequence<T> sequence) {
        return StandardCursor.of(new SequenceSource(sequence));
    }

    @Immutable
    private static class SequenceSource<T>
    implements StandardCursor.Source<T> {
        private final Sequence<T> sequence;

        private SequenceSource(Sequence<T> sequence) {
            this.sequence = sequence;
        }

        @Override
        public boolean atEnd() {
            return this.sequence.isEmpty();
        }

        @Override
        public T currentValue() {
            return this.sequence.getHead();
        }

        @Override
        public StandardCursor.Source<T> advance() {
            return new SequenceSource<T>(this.sequence.getTail());
        }
    }
}

