/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.cursors;

import javax.annotation.Nonnull;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Cursorable;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.SplitCursor;
import org.javimmutable.collections.cursors.AbstractStartCursor;
import org.javimmutable.collections.cursors.AbstractStartedCursor;
import org.javimmutable.collections.cursors.EmptyStartedCursor;
import org.javimmutable.collections.cursors.StandardCursor;
import org.javimmutable.collections.cursors.TransformCursor;

public class LazyMultiCursor<T>
extends AbstractStartedCursor<T> {
    @Nonnull
    private final Cursor<Cursorable<T>> source;
    @Nonnull
    private final Cursor<T> cursor;

    private LazyMultiCursor(@Nonnull Cursor<Cursorable<T>> source, @Nonnull Cursor<T> cursor) {
        this.source = source;
        this.cursor = cursor;
    }

    public static <T> Cursor<T> cursor(final @Nonnull Cursor<Cursorable<T>> source) {
        return new AbstractStartCursor<T>(){

            @Override
            @Nonnull
            public Cursor<T> next() {
                return LazyMultiCursor.advance(source.start());
            }
        };
    }

    public static <T> Cursor<T> cursor(@Nonnull Indexed<Cursorable<T>> source) {
        return LazyMultiCursor.cursor(StandardCursor.of(source));
    }

    public static <S, T> Cursor<T> transformed(Indexed<S> source, Func1<S, Cursorable<T>> transforminator) {
        return LazyMultiCursor.transformed(StandardCursor.of(source), transforminator);
    }

    public static <S, T> Cursor<T> transformed(Cursor<S> source, Func1<S, Cursorable<T>> transforminator) {
        return LazyMultiCursor.cursor(TransformCursor.of(source, transforminator));
    }

    public static <T> Cursorable<T> cursorable(@Nonnull Cursor<Cursorable<T>> sources) {
        return () -> LazyMultiCursor.cursor(sources);
    }

    public static <T> Cursorable<T> cursorable(@Nonnull Indexed<Cursorable<T>> sources) {
        return () -> LazyMultiCursor.cursor(sources);
    }

    private static <T> Cursor<T> resumeAfterSplitCursor(final @Nonnull Cursor<Cursorable<T>> source, final @Nonnull Cursor<T> cursor) {
        return new AbstractStartCursor<T>(){

            @Override
            @Nonnull
            public Cursor<T> next() {
                return new LazyMultiCursor(source, cursor);
            }
        };
    }

    private static <T> Cursor<T> advance(Cursor<Cursorable<T>> source) {
        while (source.hasValue()) {
            Cursor<T> cursor = source.getValue().cursor().start();
            if (cursor.hasValue()) {
                return new LazyMultiCursor<T>(source, cursor);
            }
            source = source.next();
        }
        return EmptyStartedCursor.of();
    }

    @Override
    @Nonnull
    public Cursor<T> next() {
        Cursor<T> nextCursor;
        if (this.cursor.hasValue() && (nextCursor = this.cursor.next()).hasValue()) {
            return new LazyMultiCursor<T>(this.source, nextCursor);
        }
        return LazyMultiCursor.advance(this.source.next());
    }

    @Override
    public boolean hasValue() {
        return this.cursor.hasValue();
    }

    @Override
    public T getValue() {
        return this.cursor.getValue();
    }

    @Override
    public boolean isSplitAllowed() {
        return this.source.isSplitAllowed();
    }

    @Override
    public SplitCursor<T> splitCursor() {
        SplitCursor<Cursorable<T>> split = this.source.splitCursor();
        return new SplitCursor<T>(LazyMultiCursor.resumeAfterSplitCursor(split.getLeft().start(), this.cursor), LazyMultiCursor.cursor(split.getRight()));
    }
}

