/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.cursors;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Cursorable;
import org.javimmutable.collections.Func0;
import org.javimmutable.collections.cursors.AbstractStartCursor;

@Immutable
public class LazyCursor<V>
extends AbstractStartCursor<V> {
    private final Func0<Cursor<V>> factory;

    public LazyCursor(Func0<Cursor<V>> factory) {
        this.factory = factory;
    }

    public LazyCursor(final Cursorable<V> cursorable) {
        this.factory = new Func0<Cursor<V>>(){

            @Override
            public Cursor<V> apply() {
                return cursorable.cursor();
            }
        };
    }

    public static <V> LazyCursor<V> of(Func0<Cursor<V>> factory) {
        return new LazyCursor<V>(factory);
    }

    public static <V> LazyCursor<V> of(Cursorable<V> cursorable) {
        return new LazyCursor<V>(cursorable);
    }

    @Override
    @Nonnull
    public Cursor<V> next() {
        return this.factory.apply().start();
    }
}

