/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.cursors;

import java.util.NoSuchElementException;
import java.util.Spliterator;
import javax.annotation.Nonnull;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.SplitCursor;
import org.javimmutable.collections.SplitIterator;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.cursors.CursorSpliterator;

public class IteratorAdaptor<T>
implements SplitableIterator<T> {
    private boolean starting = true;
    private Cursor<T> cursor;

    public IteratorAdaptor(Cursor<T> cursor) {
        this.cursor = cursor;
    }

    public static <V> IteratorAdaptor<V> of(Cursor<V> cursor) {
        return new IteratorAdaptor<V>(cursor);
    }

    @Override
    public boolean hasNext() {
        this.start();
        return this.cursor.hasValue();
    }

    @Override
    public T next() {
        try {
            this.start();
            T answer = this.cursor.getValue();
            this.cursor = this.cursor.next();
            return answer;
        }
        catch (Cursor.NoValueException ignored) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSplitAllowed() {
        return this.cursor.isSplitAllowed();
    }

    @Override
    @Nonnull
    public SplitIterator<T> splitIterator() {
        if (!this.cursor.isSplitAllowed()) {
            throw new UnsupportedOperationException();
        }
        SplitCursor<T> split = this.cursor.splitCursor();
        return new SplitIterator<T>(IteratorAdaptor.of(split.getLeft()), IteratorAdaptor.of(split.getRight()));
    }

    @Override
    @Nonnull
    public Spliterator<T> spliterator(int characteristics) {
        return new CursorSpliterator<T>(characteristics, this.cursor);
    }

    private void start() {
        if (this.starting) {
            this.starting = false;
            this.cursor = this.cursor.start();
        }
    }
}

