/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.cursors;

import java.util.Iterator;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.cursors.ValueFunction;
import org.javimmutable.collections.cursors.ValueFunctionCursor;
import org.javimmutable.collections.cursors.ValueFunctionFactory;

@Immutable
public abstract class IterableCursor {
    public static <T> Cursor<T> of(Iterable<T> iterable) {
        return ValueFunctionCursor.of(new Factory(iterable));
    }

    private static class Function<T>
    implements ValueFunction<T> {
        private final Iterator<T> iterator;

        private Function(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public Holder<T> nextValue() {
            return this.iterator.hasNext() ? Holders.of(this.iterator.next()) : Holders.of();
        }
    }

    private static class Factory<T>
    implements ValueFunctionFactory<T, Function<T>> {
        private final Iterable<T> iterable;

        private Factory(Iterable<T> iterable) {
            this.iterable = iterable;
        }

        @Override
        public Function<T> createFunction() {
            return new Function(this.iterable.iterator());
        }
    }
}

