/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.cursors;

import org.javimmutable.collections.Cursor;

public final class Cursors {
    private Cursors() {
    }

    public static int computeHashCode(Cursor<?> cursor) {
        int answer = 0;
        cursor = cursor.start();
        while (cursor.hasValue()) {
            Object value = cursor.getValue();
            answer = 31 * answer + (value != null ? value.hashCode() : 0);
            cursor = cursor.next();
        }
        return answer;
    }

    public static boolean areEqual(Cursor<?> a, Cursor<?> b) {
        a = a.start();
        b = b.start();
        while (a.hasValue() && b.hasValue()) {
            Object av = a.getValue();
            Object bv = b.getValue();
            if (av == null) {
                if (bv != null) {
                    return false;
                }
            } else {
                if (bv == null) {
                    return false;
                }
                if (!av.equals(bv)) {
                    return false;
                }
            }
            a = a.next();
            b = b.next();
        }
        return a.hasValue() == b.hasValue();
    }

    public static String makeString(Cursor<?> cursor) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        cursor = cursor.start();
        while (cursor.hasValue()) {
            Object value;
            if (sb.length() > 1) {
                sb.append(",");
            }
            if ((value = cursor.getValue()) == null) {
                sb.append("null");
            } else {
                sb.append(value);
            }
            cursor = cursor.next();
        }
        sb.append("]");
        return sb.toString();
    }
}

