/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.cursors;

import javax.annotation.Nonnull;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Cursorable;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.cursors.StandardCursor;

public class CursorableCursors<T, C extends Cursorable<T>>
implements Cursorable<Cursorable<T>> {
    private final Indexed<C> sources;

    private CursorableCursors(@Nonnull Indexed<C> sources) {
        this.sources = sources;
    }

    @Override
    @Nonnull
    public Cursor<Cursorable<T>> cursor() {
        return StandardCursor.of(new CursorableSource(0));
    }

    @Nonnull
    public static <T, C extends Cursorable<T>> Cursorable<Cursorable<T>> of(@Nonnull Indexed<C> sources) {
        return new CursorableCursors<T, C>(sources);
    }

    private class CursorableSource
    implements StandardCursor.Source<Cursorable<T>> {
        private final int index;

        private CursorableSource(int index) {
            this.index = index;
        }

        @Override
        public boolean atEnd() {
            return this.index >= CursorableCursors.this.sources.size();
        }

        @Override
        public Cursorable<T> currentValue() {
            return (Cursorable)CursorableCursors.this.sources.get(this.index);
        }

        @Override
        public StandardCursor.Source<Cursorable<T>> advance() {
            return new CursorableSource(this.index + 1);
        }
    }
}

