/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.cursors;

import java.util.Spliterator;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.SplitCursor;

public class CursorSpliterator<T>
implements Spliterator<T> {
    private final int characteristics;
    private Cursor<T> cursor;

    public CursorSpliterator(int characteristics, @Nonnull Cursor<T> cursor) {
        this.characteristics = characteristics;
        this.cursor = cursor.start();
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.cursor.hasValue()) {
            action.accept(this.cursor.getValue());
            this.cursor = this.cursor.next();
            return true;
        }
        return false;
    }

    @Override
    public Spliterator<T> trySplit() {
        if (this.cursor.isSplitAllowed()) {
            SplitCursor<T> split = this.cursor.splitCursor();
            this.cursor = split.getRight().start();
            return new CursorSpliterator<T>(this.characteristics, split.getLeft());
        }
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }
}

