/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ExpectedOrderSorter<T> {
    private final Map<T, Integer> ordering;

    public ExpectedOrderSorter(Iterator<T> iterator) {
        HashMap<T, Integer> ordering = new HashMap<T, Integer>();
        while (iterator.hasNext()) {
            ordering.put(iterator.next(), ordering.size());
        }
        this.ordering = Collections.unmodifiableMap(ordering);
    }

    public <U, C extends Collection<U>> List<U> sort(@Nonnull C collection, @Nonnull Function<U, T> mapper) {
        ArrayList<U> sorted = new ArrayList<U>();
        sorted.addAll(collection);
        sorted.sort(this.comparator(mapper));
        return sorted;
    }

    public <U> Iterator<U> sort(@Nonnull Iterator<U> iterator, @Nonnull Function<U, T> mapper) {
        ArrayList<U> sorted = new ArrayList<U>();
        while (iterator.hasNext()) {
            sorted.add(iterator.next());
        }
        sorted.sort(this.comparator(mapper));
        return sorted.iterator();
    }

    private <U> Comparator<U> comparator(final @Nonnull Function<U, T> mapper) {
        return new Comparator<U>(){

            @Override
            public int compare(U a, U b) {
                Integer aOrder = this.orderOf(mapper.apply(a));
                Integer bOrder = this.orderOf(mapper.apply(b));
                return aOrder - bOrder;
            }

            private int orderOf(T key) {
                Integer answer = (Integer)ExpectedOrderSorter.this.ordering.get(key);
                if (answer == null) {
                    throw new IllegalArgumentException();
                }
                return answer;
            }
        };
    }
}

