/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.common;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.IterableStreamable;
import org.javimmutable.collections.JImmutableArray;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.MapEntry;
import org.javimmutable.collections.iterators.TransformStreamable;

@Immutable
public class ArrayToMapAdaptor<T>
extends AbstractMap<Integer, T> {
    private final JImmutableArray<T> map;

    public ArrayToMapAdaptor(JImmutableArray<T> map) {
        this.map = map;
    }

    public static <V> ArrayToMapAdaptor<V> of(JImmutableArray<V> map) {
        return new ArrayToMapAdaptor<V>(map);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.map.find((Integer)o).isFilled();
    }

    @Override
    public boolean containsValue(Object o) {
        for (JImmutableMap.Entry entry : this.map) {
            Object value = entry.getValue();
            if (!(o == null ? value == null : value != null && value.equals(o))) continue;
            return true;
        }
        return false;
    }

    @Override
    public T get(Object o) {
        return this.map.get((Integer)o);
    }

    @Override
    public T put(Integer k, T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends T> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Integer> keySet() {
        return new AbstractSet<Integer>(){

            @Override
            public boolean isEmpty() {
                return ArrayToMapAdaptor.this.map.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return ArrayToMapAdaptor.this.map.find((Integer)o).isFilled();
            }

            @Override
            public Iterator<Integer> iterator() {
                return ArrayToMapAdaptor.this.map.keys().iterator();
            }

            @Override
            public Spliterator<Integer> spliterator() {
                return ArrayToMapAdaptor.this.map.keys().spliterator();
            }

            @Override
            public int size() {
                return ArrayToMapAdaptor.this.map.size();
            }
        };
    }

    @Override
    public Collection<T> values() {
        return new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                return ArrayToMapAdaptor.this.map.values().iterator();
            }

            @Override
            public Spliterator<T> spliterator() {
                return ArrayToMapAdaptor.this.map.values().spliterator();
            }

            @Override
            public int size() {
                return ArrayToMapAdaptor.this.map.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<Integer, T>> entrySet() {
        return new AbstractSet<Map.Entry<Integer, T>>(){

            @Override
            public boolean isEmpty() {
                return ArrayToMapAdaptor.this.map.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry oEntry = (Map.Entry)o;
                Holder eHolder = ArrayToMapAdaptor.this.map.findEntry((Integer)oEntry.getKey());
                return eHolder.isFilled() && new MapEntry(eHolder.getValue()).equals(oEntry);
            }

            @Override
            public Iterator<Map.Entry<Integer, T>> iterator() {
                return this.streamable().iterator();
            }

            @Override
            public Spliterator<Map.Entry<Integer, T>> spliterator() {
                return this.streamable().spliterator();
            }

            @Override
            public int size() {
                return ArrayToMapAdaptor.this.map.size();
            }

            @Nonnull
            private IterableStreamable<Map.Entry<Integer, T>> streamable() {
                return TransformStreamable.of(ArrayToMapAdaptor.this.map, e -> MapEntry.of(e));
            }
        };
    }
}

