/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.common;

import java.lang.reflect.Array;
import javax.annotation.Nonnull;

public final class ArrayHelper {
    @Nonnull
    public static <T> T[] subArray(@Nonnull Allocator<T> allocator, @Nonnull T[] orig, int offset, int limit) {
        int length = limit - offset;
        T[] answer = allocator.allocate(length);
        System.arraycopy(orig, offset, answer, 0, length);
        return answer;
    }

    @Nonnull
    public static <T> T[] subArray(@Nonnull Allocator<T> allocator, @Nonnull T[] a, @Nonnull T[] b, int offset, int limit) {
        int length = limit - offset;
        T[] answer = allocator.allocate(length);
        if (offset > a.length) {
            System.arraycopy(b, offset - a.length, answer, 0, length);
        } else if (limit <= a.length) {
            System.arraycopy(a, offset, answer, 0, length);
        } else {
            int alength = a.length - offset;
            System.arraycopy(a, offset, answer, 0, alength);
            System.arraycopy(b, 0, answer, alength, length - alength);
        }
        return answer;
    }

    @Nonnull
    public static <T> T[] assign(@Nonnull T[] orig, int index, T value) {
        Object[] answer = (Object[])orig.clone();
        answer[index] = value;
        return answer;
    }

    @Nonnull
    public static <T> T[] append(@Nonnull Allocator<T> allocator, @Nonnull T[] orig, T value) {
        T[] answer = allocator.allocate(orig.length + 1);
        System.arraycopy(orig, 0, answer, 0, orig.length);
        answer[orig.length] = value;
        return answer;
    }

    @Nonnull
    public static <T> T[] insert(@Nonnull Allocator<T> allocator, @Nonnull T[] orig, int index, T value) {
        if (index == orig.length) {
            return ArrayHelper.append(allocator, orig, value);
        }
        T[] answer = allocator.allocate(orig.length + 1);
        System.arraycopy(orig, 0, answer, 0, index);
        System.arraycopy(orig, index, answer, index + 1, orig.length - index);
        answer[index] = value;
        return answer;
    }

    @Nonnull
    public static <T> T[] delete(@Nonnull Allocator<T> allocator, @Nonnull T[] orig, int index) {
        T[] answer = allocator.allocate(orig.length - 1);
        System.arraycopy(orig, 0, answer, 0, index);
        System.arraycopy(orig, index + 1, answer, index, orig.length - index - 1);
        return answer;
    }

    @Nonnull
    public static <T> T[] concat(@Nonnull Allocator<T> allocator, @Nonnull T[] a, @Nonnull T[] b) {
        T[] answer = allocator.allocate(a.length + b.length);
        System.arraycopy(a, 0, answer, 0, a.length);
        System.arraycopy(b, 0, answer, a.length, b.length);
        return answer;
    }

    @Nonnull
    public static <T> T[] assignAppend(@Nonnull Allocator<T> allocator, @Nonnull T[] orig, T assignValue, T appendValue) {
        T[] answer = allocator.allocate(orig.length + 1);
        System.arraycopy(orig, 0, answer, 0, orig.length - 1);
        answer[orig.length - 1] = assignValue;
        answer[orig.length] = appendValue;
        return answer;
    }

    @Nonnull
    public static <T> T[] assignTwo(@Nonnull T[] orig, int index, T first, T second) {
        Object[] answer = (Object[])orig.clone();
        answer[index] = first;
        answer[index + 1] = second;
        return answer;
    }

    @Nonnull
    public static <T> T[] assignInsert(@Nonnull Allocator<T> allocator, @Nonnull T[] orig, int index, T assignValue, T insertValue) {
        T[] answer = allocator.allocate(orig.length + 1);
        System.arraycopy(orig, 0, answer, 0, index);
        System.arraycopy(orig, index, answer, index + 1, orig.length - index);
        answer[index] = assignValue;
        answer[index + 1] = insertValue;
        return answer;
    }

    @Nonnull
    public static <T> T[] assignDelete(@Nonnull Allocator<T> allocator, @Nonnull T[] orig, int index, T newNode) {
        T[] answer = allocator.allocate(orig.length - 1);
        System.arraycopy(orig, 0, answer, 0, index);
        System.arraycopy(orig, index + 1, answer, index, orig.length - index - 1);
        answer[index] = newNode;
        return answer;
    }

    @Nonnull
    public static <T> Allocator<T> allocator(final Class<T> klass) {
        return new Allocator<T>(){

            @Override
            @Nonnull
            public T[] allocate(int size) {
                return (Object[])Array.newInstance(klass, size);
            }
        };
    }

    public static interface Allocator<T> {
        @Nonnull
        public T[] allocate(int var1);
    }
}

