/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.common;

import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.JImmutableMultiset;
import org.javimmutable.collections.JImmutableSet;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.common.SetAdaptor;
import org.javimmutable.collections.cursors.Cursors;

@Immutable
public abstract class AbstractJImmutableSet<T>
implements JImmutableSet<T> {
    protected final JImmutableMap<T, Boolean> map;

    protected AbstractJImmutableSet(JImmutableMap<T, Boolean> map) {
        this.map = map;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> insert(@Nonnull T value) {
        JImmutableMap<T, Boolean> newMap = this.map.assign(value, Boolean.TRUE);
        return newMap != this.map ? this.create(newMap) : this;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> getInsertableSelf() {
        return this;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> insertAll(@Nonnull Iterable<? extends T> values) {
        return this.union(values.iterator());
    }

    @Override
    @Nonnull
    public JImmutableSet<T> insertAll(@Nonnull Cursor<? extends T> values) {
        return this.union(values.iterator());
    }

    @Override
    @Nonnull
    public JImmutableSet<T> insertAll(@Nonnull Iterator<? extends T> values) {
        return this.union(values);
    }

    @Override
    public boolean contains(@Nullable T value) {
        return value != null && this.map.getValueOr(value, Boolean.FALSE) != false;
    }

    @Override
    public boolean containsAll(@Nonnull Iterable<? extends T> values) {
        return this.containsAll(values.iterator());
    }

    @Override
    public boolean containsAll(@Nonnull Cursor<? extends T> values) {
        Cursor<T> c = values.start();
        while (c.hasValue()) {
            if (!this.contains(c.getValue())) {
                return false;
            }
            c = c.next();
        }
        return true;
    }

    @Override
    public boolean containsAll(@Nonnull Iterator<? extends T> values) {
        while (values.hasNext()) {
            if (this.contains(values.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAny(@Nonnull Iterable<? extends T> values) {
        return this.containsAny(values.iterator());
    }

    @Override
    public boolean containsAny(@Nonnull Cursor<? extends T> values) {
        Cursor<T> c = values.start();
        while (c.hasValue()) {
            if (this.contains(c.getValue())) {
                return true;
            }
            c = c.next();
        }
        return false;
    }

    @Override
    public boolean containsAny(@Nonnull Iterator<? extends T> values) {
        while (values.hasNext()) {
            if (!this.contains(values.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> delete(T value) {
        JImmutableMap<T, Boolean> newMap = this.map.delete(value);
        return newMap != this.map ? this.create(newMap) : this;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> deleteAll(@Nonnull Iterable<? extends T> other) {
        return this.deleteAll(other.iterator());
    }

    @Override
    @Nonnull
    public JImmutableSet<T> deleteAll(@Nonnull Cursor<? extends T> values) {
        return this.deleteAll(values.iterator());
    }

    @Override
    @Nonnull
    public JImmutableSet<T> deleteAll(@Nonnull Iterator<? extends T> values) {
        JImmutableMap<T, Boolean> newMap = this.map;
        while (values.hasNext()) {
            T value = values.next();
            if (value == null) continue;
            newMap = newMap.delete(value);
        }
        return newMap != this.map ? this.create(newMap) : this;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> union(@Nonnull Iterable<? extends T> other) {
        return this.union(other.iterator());
    }

    @Override
    @Nonnull
    public JImmutableSet<T> union(@Nonnull Cursor<? extends T> values) {
        return this.union(values.iterator());
    }

    @Override
    @Nonnull
    public JImmutableSet<T> union(@Nonnull Iterator<? extends T> values) {
        JImmutableMap<T, Boolean> newMap = this.map;
        while (values.hasNext()) {
            T value = values.next();
            if (value == null) continue;
            newMap = newMap.assign(value, Boolean.TRUE);
        }
        return newMap != this.map ? this.create(newMap) : this;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> intersection(@Nonnull Iterable<? extends T> other) {
        return this.intersection(other.iterator());
    }

    @Override
    @Nonnull
    public JImmutableSet<T> intersection(@Nonnull Cursor<? extends T> values) {
        return this.intersection(values.iterator());
    }

    @Override
    @Nonnull
    public JImmutableSet<T> intersection(@Nonnull Iterator<? extends T> values) {
        if (this.isEmpty()) {
            return this;
        }
        if (!values.hasNext()) {
            return this.deleteAll();
        }
        Set<T> otherSet = this.emptyMutableSet();
        while (values.hasNext()) {
            T value = values.next();
            if (value == null) continue;
            otherSet.add(value);
        }
        JImmutableMap<T, Boolean> newMap = this.map;
        for (JImmutableMap.Entry entry : this.map) {
            if (otherSet.contains(entry.getKey())) continue;
            newMap = newMap.delete(entry.getKey());
        }
        return newMap != this.map ? this.create(newMap) : this;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> intersection(@Nonnull JImmutableSet<? extends T> other) {
        return this.intersection(other.getSet());
    }

    @Override
    @Nonnull
    public JImmutableSet<T> intersection(@Nonnull Set<? extends T> other) {
        if (this.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return this.deleteAll();
        }
        JImmutableMap<T, Boolean> newMap = this.map;
        for (Object value : this.map.keysCursor()) {
            if (other.contains(value)) continue;
            newMap = newMap.delete(value);
        }
        return newMap != this.map ? this.create(newMap) : this;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    @Nonnull
    public Set<T> getSet() {
        return SetAdaptor.of(this);
    }

    @Override
    @Nonnull
    public Cursor<T> cursor() {
        return this.map.keysCursor();
    }

    @Override
    @Nonnull
    public SplitableIterator<T> iterator() {
        return this.map.keys().iterator();
    }

    @Override
    public int getSpliteratorCharacteristics() {
        return this.map.keys().getSpliteratorCharacteristics();
    }

    public int hashCode() {
        return Cursors.computeHashCode(this.cursor());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof JImmutableMultiset) {
            return o.equals(this);
        }
        if (o instanceof JImmutableSet) {
            return this.getSet().equals(((JImmutableSet)o).getSet());
        }
        return o instanceof Set && this.getSet().equals(o);
    }

    public String toString() {
        return Cursors.makeString(this.cursor());
    }

    @Override
    public void checkInvariants() {
        this.checkSetInvariants();
    }

    protected void checkSetInvariants() {
        this.map.checkInvariants();
        for (JImmutableMap.Entry entry : this.map.cursor()) {
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            throw new RuntimeException();
        }
    }

    protected abstract JImmutableSet<T> create(JImmutableMap<T, Boolean> var1);

    protected abstract Set<T> emptyMutableSet();
}

