/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.common;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.IterableStreamable;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.MapEntry;
import org.javimmutable.collections.common.MapAdaptor;
import org.javimmutable.collections.cursors.TransformCursor;
import org.javimmutable.collections.iterators.TransformStreamable;

@Immutable
public abstract class AbstractJImmutableMap<K, V>
implements JImmutableMap<K, V> {
    @Override
    @Nullable
    public V get(K key) {
        return this.getValueOr(key, null);
    }

    @Override
    @Nonnull
    public JImmutableMap<K, V> insert(@Nonnull JImmutableMap.Entry<K, V> e) {
        return this.assign(e.getKey(), e.getValue());
    }

    @Override
    @Nonnull
    public JImmutableMap<K, V> getInsertableSelf() {
        return this;
    }

    @Override
    @Nonnull
    public JImmutableMap<K, V> assignAll(@Nonnull JImmutableMap<? extends K, ? extends V> map) {
        return this.assignAllHelper(map);
    }

    @Override
    @Nonnull
    public JImmutableMap<K, V> assignAll(@Nonnull Map<? extends K, ? extends V> map) {
        JImmutableMap<K, V> answer = this;
        for (Map.Entry<K, V> e : map.entrySet()) {
            answer = answer.assign(e.getKey(), e.getValue());
        }
        return answer;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @Nonnull
    public Cursor<K> keysCursor() {
        return TransformCursor.ofKeys(this.cursor());
    }

    @Override
    @Nonnull
    public Cursor<V> valuesCursor() {
        return TransformCursor.ofValues(this.cursor());
    }

    @Override
    @Nonnull
    public Map<K, V> getMap() {
        return MapAdaptor.of(this);
    }

    @Override
    @Nonnull
    public IterableStreamable<K> keys() {
        return TransformStreamable.ofKeys(this);
    }

    @Override
    @Nonnull
    public IterableStreamable<V> values() {
        return TransformStreamable.ofValues(this);
    }

    public int hashCode() {
        return this.getMap().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JImmutableMap) {
            return this.getMap().equals(((JImmutableMap)o).getMap());
        }
        return o instanceof Map && this.getMap().equals(o);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Cursor cursor = this.cursor().start();
        while (cursor.hasValue()) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            MapEntry.addToString(sb, (JImmutableMap.Entry)cursor.getValue());
            cursor = cursor.next();
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public int getSpliteratorCharacteristics() {
        return 1024;
    }

    @Nonnull
    private <K1 extends K, V1 extends V> JImmutableMap<K, V> assignAllHelper(@Nonnull JImmutableMap<K1, V1> map) {
        JImmutableMap<K, V> answer = this;
        Cursor c = map.cursor();
        c = c.start();
        while (c.hasValue()) {
            JImmutableMap.Entry e = (JImmutableMap.Entry)c.getValue();
            answer = answer.assign(e.getKey(), e.getValue());
            c = c.next();
        }
        return answer;
    }
}

