/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.common;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.IterableStreamable;
import org.javimmutable.collections.JImmutableArray;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.MapEntry;
import org.javimmutable.collections.common.ArrayToMapAdaptor;
import org.javimmutable.collections.cursors.TransformCursor;
import org.javimmutable.collections.iterators.TransformStreamable;

@Immutable
public abstract class AbstractJImmutableArray<T>
implements JImmutableArray<T> {
    @Override
    @Nullable
    public T get(int index) {
        return this.find(index).getValueOrNull();
    }

    @Override
    @Nonnull
    public Holder<JImmutableMap.Entry<Integer, T>> findEntry(int key) {
        Holder value = this.find(key);
        return value.isFilled() ? Holders.of(MapEntry.of(key, value.getValue())) : Holders.of();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @Nonnull
    public JImmutableArray<T> insert(@Nullable JImmutableMap.Entry<Integer, T> e) {
        return e == null ? this : this.assign(e.getKey(), e.getValue());
    }

    @Override
    @Nonnull
    public JImmutableArray<T> getInsertableSelf() {
        return this;
    }

    @Override
    @Nonnull
    public Cursor<Integer> keysCursor() {
        return TransformCursor.ofKeys(this.cursor());
    }

    @Override
    @Nonnull
    public Cursor<T> valuesCursor() {
        return TransformCursor.ofValues(this.cursor());
    }

    @Override
    @Nonnull
    public IterableStreamable<Integer> keys() {
        return TransformStreamable.ofKeys(this);
    }

    @Override
    @Nonnull
    public IterableStreamable<T> values() {
        return TransformStreamable.ofValues(this);
    }

    @Override
    public int getSpliteratorCharacteristics() {
        return 1040;
    }

    @Override
    @Nonnull
    public Map<Integer, T> getMap() {
        return ArrayToMapAdaptor.of(this);
    }
}

