/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.btree_list;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.JImmutableList;
import org.javimmutable.collections.JImmutableRandomAccessList;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.btree_list.BtreeBranchNode;
import org.javimmutable.collections.btree_list.BtreeEmptyNode;
import org.javimmutable.collections.btree_list.BtreeInsertResult;
import org.javimmutable.collections.btree_list.BtreeLeafNode;
import org.javimmutable.collections.btree_list.BtreeNode;
import org.javimmutable.collections.btree_list.BtreeNodeBuilder;
import org.javimmutable.collections.common.ListAdaptor;
import org.javimmutable.collections.indexed.IndexedList;
import org.javimmutable.collections.iterators.IteratorHelper;
import org.javimmutable.collections.serialization.JImmutableRandomAccessListProxy;

@Immutable
public class JImmutableBtreeList<T>
implements JImmutableRandomAccessList<T>,
Serializable {
    private static final JImmutableBtreeList<Object> EMPTY = new JImmutableBtreeList(BtreeEmptyNode.of());
    private static final long serialVersionUID = -121805L;
    private final BtreeNode<T> root;

    public static <T> JImmutableBtreeList<T> of() {
        return EMPTY;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Nonnull
    public static <T> Collector<T, ?, JImmutableRandomAccessList<T>> collector() {
        return Collector.of(() -> new Builder(), (b, v) -> b.add(v), (b1, b2) -> b1.combineWith(b2), b -> b.build(), new Collector.Characteristics[0]);
    }

    @Nonnull
    public static <T> JImmutableBtreeList<T> of(@Nonnull Indexed<? extends T> values) {
        int nodeCount = values.size();
        if (nodeCount == 0) {
            return JImmutableBtreeList.of();
        }
        if (nodeCount <= 18) {
            return new JImmutableBtreeList<T>(BtreeLeafNode.of(values, 0, nodeCount));
        }
        ArrayList<BtreeNode<Object>> nodes = new ArrayList<BtreeNode<Object>>();
        int remaining = nodeCount;
        int offset = 0;
        while (remaining > 0) {
            BtreeLeafNode<? extends T> node;
            if (remaining <= 18) {
                node = BtreeLeafNode.of(values, offset, Math.min(offset + 18, nodeCount));
                remaining = 0;
                offset = nodeCount;
            } else {
                node = BtreeLeafNode.of(values, offset, offset + 9);
                remaining -= 9;
                offset += 9;
            }
            nodes.add(node);
        }
        nodeCount = nodes.size();
        IndexedList indexed = IndexedList.retained(nodes);
        while (nodeCount > 1) {
            remaining = nodeCount;
            offset = 0;
            int branchCount = 0;
            while (remaining > 0) {
                BtreeBranchNode node;
                if (remaining <= 18) {
                    node = BtreeBranchNode.of(indexed, offset, Math.min(offset + 18, nodeCount));
                    remaining = 0;
                    offset = nodeCount;
                } else {
                    node = BtreeBranchNode.of(indexed, offset, offset + 9);
                    remaining -= 9;
                    offset += 9;
                }
                nodes.set(branchCount, node);
                ++branchCount;
            }
            nodeCount = branchCount;
        }
        return new JImmutableBtreeList<T>((BtreeNode)nodes.get(0));
    }

    private JImmutableBtreeList(BtreeNode<T> root) {
        this.root = root;
    }

    private static <T> JImmutableBtreeList<T> create(BtreeInsertResult<T> insertResult) {
        if (insertResult.type == BtreeInsertResult.Type.INPLACE) {
            return new JImmutableBtreeList(insertResult.newNode);
        }
        return new JImmutableBtreeList(new BtreeBranchNode(insertResult.newNode, insertResult.extraNode));
    }

    private JImmutableBtreeList<T> createForDelete(@Nonnull BtreeNode<T> newRoot) {
        if (newRoot.valueCount() == 0) {
            return JImmutableBtreeList.of();
        }
        return new JImmutableBtreeList<T>(newRoot.compress());
    }

    @Override
    @Nonnull
    public JImmutableBtreeList<T> assign(int index, @Nullable T value) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return new JImmutableBtreeList<T>(this.root.assign(index, value));
    }

    @Override
    @Nonnull
    public JImmutableBtreeList<T> insert(@Nullable T value) {
        return JImmutableBtreeList.create(this.root.append(value));
    }

    @Override
    @Nonnull
    public JImmutableBtreeList<T> insert(int index, @Nullable T value) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return JImmutableBtreeList.create(this.root.insertAt(index, value));
    }

    @Override
    @Nonnull
    public JImmutableBtreeList<T> getInsertableSelf() {
        return this;
    }

    @Override
    @Nonnull
    public JImmutableBtreeList<T> insertFirst(@Nullable T value) {
        return JImmutableBtreeList.create(this.root.insertAt(0, value));
    }

    @Override
    @Nonnull
    public JImmutableBtreeList<T> insertLast(@Nullable T value) {
        return JImmutableBtreeList.create(this.root.append(value));
    }

    @Override
    @Nonnull
    public JImmutableBtreeList<T> insertAll(@Nonnull Iterable<? extends T> values) {
        return this.insertAllLast((Iterable)values);
    }

    @Override
    @Nonnull
    public JImmutableBtreeList<T> insertAll(@Nonnull Cursor<? extends T> values) {
        return this.insertAllLast((Cursor)values);
    }

    @Override
    @Nonnull
    public JImmutableBtreeList<T> insertAll(@Nonnull Iterator<? extends T> values) {
        return this.insertAllLast((Iterator)values);
    }

    @Override
    @Nonnull
    public JImmutableBtreeList<T> insertAll(int index, @Nonnull Iterable<? extends T> values) {
        return this.insertAll(index, (Iterator)values.iterator());
    }

    @Override
    @Nonnull
    public JImmutableBtreeList<T> insertAll(int index, @Nonnull Cursor<? extends T> values) {
        return this.insertAll(index, values.iterator());
    }

    @Override
    @Nonnull
    public JImmutableBtreeList<T> insertAll(int index, @Nonnull Iterator<? extends T> values) {
        BtreeNode<T> newRoot;
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.size()) {
            BtreeNodeBuilder<Object> builder = new BtreeNodeBuilder<Object>();
            if (this.root.depth() == 1) {
                for (Object t : this.root) {
                    builder.add(t);
                }
            } else {
                builder.rebuild(this.root);
            }
            while (values.hasNext()) {
                builder.add(values.next());
            }
            newRoot = builder.build();
        } else {
            int i = index;
            newRoot = this.root;
            while (values.hasNext()) {
                BtreeInsertResult<T> insertResult = newRoot.insertAt(i, values.next());
                newRoot = insertResult.type == BtreeInsertResult.Type.INPLACE ? insertResult.newNode : new BtreeBranchNode(insertResult.newNode, insertResult.extraNode);
                ++i;
            }
        }
        return this.root == newRoot ? this : new JImmutableBtreeList<T>(newRoot);
    }

    @Override
    @Nonnull
    public JImmutableBtreeList<T> insertAllFirst(@Nonnull Iterable<? extends T> values) {
        if (values instanceof JImmutableBtreeList) {
            return JImmutableBtreeList.combine((JImmutableBtreeList)values, this);
        }
        return this.insertAll(0, (Iterator)values.iterator());
    }

    @Override
    @Nonnull
    public JImmutableBtreeList<T> insertAllFirst(@Nonnull Cursor<? extends T> values) {
        return this.insertAll(0, values.iterator());
    }

    @Override
    @Nonnull
    public JImmutableBtreeList<T> insertAllFirst(@Nonnull Iterator<? extends T> values) {
        return this.insertAll(0, (Iterator)values);
    }

    @Override
    @Nonnull
    public JImmutableBtreeList<T> insertAllLast(@Nonnull Iterable<? extends T> values) {
        if (values instanceof JImmutableBtreeList) {
            return JImmutableBtreeList.combine(this, (JImmutableBtreeList)values);
        }
        return this.insertAll(this.size(), (Iterator)values.iterator());
    }

    @Override
    @Nonnull
    public JImmutableBtreeList<T> insertAllLast(@Nonnull Cursor<? extends T> values) {
        return this.insertAll(this.size(), values.iterator());
    }

    @Override
    @Nonnull
    public JImmutableBtreeList<T> insertAllLast(@Nonnull Iterator<? extends T> values) {
        return this.insertAll(this.size(), (Iterator)values);
    }

    @Override
    @Nonnull
    public JImmutableBtreeList<T> deleteFirst() {
        return this.createForDelete(this.root.delete(0));
    }

    @Override
    @Nonnull
    public JImmutableBtreeList<T> deleteLast() {
        return this.createForDelete(this.root.delete(this.root.valueCount() - 1));
    }

    @Override
    @Nonnull
    public JImmutableBtreeList<T> delete(int index) {
        return this.createForDelete(this.root.delete(index));
    }

    @Override
    @Nonnull
    public JImmutableBtreeList<T> deleteAll() {
        return JImmutableBtreeList.of();
    }

    @Override
    public int size() {
        return this.root.valueCount();
    }

    @Override
    public T get(int index) {
        return this.root.get(index);
    }

    @Override
    @Nonnull
    public JImmutableBtreeList<T> insert(@Nonnull Iterable<? extends T> values) {
        return this.insertAllLast((Iterable)values);
    }

    @Override
    public boolean isEmpty() {
        return this.root.valueCount() == 0;
    }

    @Override
    public <A> JImmutableRandomAccessList<A> transform(@Nonnull Func1<T, A> transform) {
        Builder<T> builder = JImmutableBtreeList.builder();
        for (Object t : this) {
            builder.add(transform.apply((T)t));
        }
        return builder.build();
    }

    @Override
    public <A> JImmutableRandomAccessList<A> transformSome(@Nonnull Func1<T, Holder<A>> transform) {
        Builder<T> builder = JImmutableBtreeList.builder();
        for (Object t : this) {
            Holder<A> ha = transform.apply((T)t);
            if (!ha.isFilled()) continue;
            builder.add(ha.getValue());
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public List<T> getList() {
        return new ListAdaptor(this);
    }

    @Override
    @Nonnull
    public Cursor<T> cursor() {
        return this.root.cursor();
    }

    @Override
    @Nonnull
    public SplitableIterator<T> iterator() {
        return this.root.iterator();
    }

    @Override
    public int getSpliteratorCharacteristics() {
        return 1040;
    }

    @Override
    public void checkInvariants() {
        this.root.checkInvariants(true);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof JImmutableList && IteratorHelper.iteratorEquals(this.iterator(), ((JImmutableList)o).iterator());
    }

    public int hashCode() {
        return IteratorHelper.iteratorHashCode(this.iterator());
    }

    public String toString() {
        return IteratorHelper.iteratorToString(this.iterator());
    }

    private Object writeReplace() {
        return new JImmutableRandomAccessListProxy(this);
    }

    private static <T> JImmutableBtreeList<T> combine(JImmutableBtreeList<T> left, JImmutableBtreeList<T> right) {
        BtreeNode<T> leftRoot = left.root;
        BtreeNode<T> rightRoot = right.root;
        int leftDepth = leftRoot.depth();
        int rightDepth = rightRoot.depth();
        if (leftDepth == 1) {
            return right.insertAll(0, left.iterator());
        }
        if (rightDepth == 1) {
            return left.insertAll(left.size(), right.iterator());
        }
        if (leftDepth < rightDepth) {
            BtreeInsertResult<T> insertResult = rightRoot.insertNode(rightDepth - leftDepth, false, leftRoot);
            return JImmutableBtreeList.create(insertResult);
        }
        BtreeInsertResult<T> insertResult = leftRoot.insertNode(leftDepth - rightDepth, true, rightRoot);
        return JImmutableBtreeList.create(insertResult);
    }

    BtreeNode<T> root() {
        return this.root;
    }

    public static class Builder<T>
    implements JImmutableRandomAccessList.Builder<T> {
        private final BtreeNodeBuilder<T> builder = new BtreeNodeBuilder();

        private Builder() {
        }

        @Override
        public int size() {
            return this.builder.size();
        }

        @Nonnull
        public Builder<T> add(T value) {
            this.builder.add(value);
            return this;
        }

        @Override
        @Nonnull
        public JImmutableBtreeList<T> build() {
            return this.builder.size() == 0 ? JImmutableBtreeList.of() : new JImmutableBtreeList(this.builder.build());
        }

        @Nonnull
        public Builder<T> combineWith(@Nonnull Builder<T> other) {
            Object a = this.build();
            Object b = other.build();
            JImmutableBtreeList ab = JImmutableBtreeList.combine((JImmutableBtreeList)a, (JImmutableBtreeList)b);
            this.builder.rebuild(ab.root);
            return this;
        }

        void checkInvariants() {
            this.builder.checkInvariants();
        }
    }
}

