/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.btree_list;

import java.util.Iterator;
import javax.annotation.Nonnull;
import org.javimmutable.collections.btree_list.BtreeBranchNode;
import org.javimmutable.collections.btree_list.BtreeEmptyNode;
import org.javimmutable.collections.btree_list.BtreeLeafNode;
import org.javimmutable.collections.btree_list.BtreeNode;
import org.javimmutable.collections.indexed.IndexedArray;
import org.javimmutable.collections.iterators.SingleValueIterator;

class BtreeNodeBuilder<T> {
    private final LeafBuilder<T> leafBuilder = new LeafBuilder();
    private int size;

    BtreeNodeBuilder() {
    }

    synchronized int size() {
        return this.size;
    }

    synchronized void add(T value) {
        ((LeafBuilder)this.leafBuilder).add(value);
        ++this.size;
    }

    synchronized void rebuild(@Nonnull BtreeNode<T> root) {
        Iterator<BtreeNode<T>> nodes;
        ((LeafBuilder)this.leafBuilder).clear();
        this.size = 0;
        Iterator<BtreeNode<T>> iterator = nodes = root.depth() > 1 ? root.childIterator() : SingleValueIterator.of(root);
        while (nodes.hasNext()) {
            BtreeNode<T> node = nodes.next();
            if (nodes.hasNext()) {
                ((LeafBuilder)this.leafBuilder).addNode(node);
                this.size += node.valueCount();
                continue;
            }
            if (node.depth() > 1) {
                nodes = node.childIterator();
                continue;
            }
            for (Object value : node) {
                ((LeafBuilder)this.leafBuilder).add(value);
            }
            this.size += node.valueCount();
        }
        assert (this.size == root.valueCount());
    }

    synchronized BtreeNode<T> build() {
        if (this.size == 0) {
            return BtreeEmptyNode.of();
        }
        return ((LeafBuilder)this.leafBuilder).build().compress();
    }

    synchronized void checkInvariants() {
        if (this.size != ((LeafBuilder)this.leafBuilder).computeSize()) {
            throw new IllegalStateException("size mismatch");
        }
        ((LeafBuilder)this.leafBuilder).checkInvariants();
    }

    private static class BranchBuilder<T> {
        private final int depth;
        private final BtreeNode<T>[] buffer;
        private int count;
        private BranchBuilder<T> parent;

        private BranchBuilder(int depth) {
            this.depth = depth;
            this.buffer = new BtreeNode[18];
        }

        private void add(@Nonnull BtreeNode<T> node) {
            assert (node.depth() == this.depth);
            assert (this.count < 18);
            this.buffer[this.count] = node;
            ++this.count;
            if (this.count == 18) {
                this.push(9);
            }
        }

        private void addNode(@Nonnull BtreeNode<T> node) {
            if (node.depth() == this.depth) {
                this.add(node);
            } else {
                assert (this.count == 0);
                if (this.parent == null) {
                    this.parent = new BranchBuilder<T>(this.depth + 1);
                }
                super.addNode(node);
            }
        }

        private BtreeNode<T> build(@Nonnull BtreeNode<T> extraNode) {
            assert (this.count < 18);
            this.buffer[this.count] = extraNode;
            BtreeBranchNode<T> node = BtreeBranchNode.of(IndexedArray.retained(this.buffer), 0, this.count + 1);
            if (this.parent == null) {
                return node;
            }
            return super.build(node);
        }

        private void push(int howMany) {
            assert (howMany <= this.count);
            assert (howMany >= 9);
            if (this.parent == null) {
                this.parent = new BranchBuilder<T>(this.depth + 1);
            }
            super.add(BtreeBranchNode.of(IndexedArray.retained(this.buffer), 0, howMany));
            System.arraycopy(this.buffer, howMany, this.buffer, 0, this.count - howMany);
            this.count -= howMany;
        }

        private int computeSize() {
            int answer = 0;
            for (int i = 0; i < this.count; ++i) {
                answer += this.buffer[i].valueCount();
            }
            if (this.parent != null) {
                answer += super.computeSize();
            }
            return answer;
        }

        private void checkInvariants() {
            if (this.parent == null) {
                if (this.count < 1) {
                    throw new IllegalStateException("count < 1");
                }
            } else if (this.count < 8) {
                throw new IllegalStateException("count < MIN_CHILDREN");
            }
            if (this.count >= 18) {
                throw new IllegalStateException("count >= MAX_CHILDREN");
            }
            for (int i = 0; i < this.count; ++i) {
                if (this.buffer[i].depth() == this.depth) continue;
                throw new IllegalStateException("wrong node depth");
            }
            if (this.parent != null) {
                super.checkInvariants();
            }
        }
    }

    private static class LeafBuilder<T> {
        private final T[] buffer = new Object[18];
        private int count;
        private BranchBuilder<T> parent;

        private LeafBuilder() {
        }

        private void add(@Nonnull T value) {
            assert (this.count < 18);
            this.buffer[this.count] = value;
            ++this.count;
            if (this.count == 18) {
                this.push(9);
            }
        }

        private void addNode(@Nonnull BtreeNode<T> node) {
            assert (this.count == 0);
            if (this.parent == null) {
                this.parent = new BranchBuilder(1);
            }
            if (node.depth() == 1) {
                ((BranchBuilder)this.parent).add(node);
            } else {
                ((BranchBuilder)this.parent).addNode(node);
            }
        }

        private BtreeNode<T> build() {
            assert (this.count > 0);
            if (this.parent == null) {
                return BtreeLeafNode.of(IndexedArray.retained(this.buffer), 0, this.count);
            }
            assert (this.count >= 9);
            return ((BranchBuilder)this.parent).build(BtreeLeafNode.of(IndexedArray.retained(this.buffer), 0, this.count));
        }

        private void clear() {
            this.count = 0;
            this.parent = null;
        }

        private void push(int howMany) {
            assert (howMany <= this.count);
            assert (howMany >= 9);
            if (this.parent == null) {
                this.parent = new BranchBuilder(1);
            }
            ((BranchBuilder)this.parent).add(BtreeLeafNode.of(IndexedArray.retained(this.buffer), 0, howMany));
            System.arraycopy(this.buffer, howMany, this.buffer, 0, this.count - howMany);
            this.count -= howMany;
        }

        private int computeSize() {
            int answer = this.count;
            if (this.parent != null) {
                answer += ((BranchBuilder)this.parent).computeSize();
            }
            return answer;
        }

        private void checkInvariants() {
            if (this.parent != null) {
                if (this.count < 9) {
                    throw new IllegalStateException("count < MIN_CHILDREN");
                }
                ((BranchBuilder)this.parent).checkInvariants();
            }
            if (this.count >= 18) {
                throw new IllegalStateException("count >= MAX_CHILDREN");
            }
        }
    }
}

