/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.btree_list;

import java.util.Iterator;
import javax.annotation.Nonnull;
import org.javimmutable.collections.Cursorable;
import org.javimmutable.collections.SplitableIterable;
import org.javimmutable.collections.Tuple2;
import org.javimmutable.collections.btree_list.BtreeInsertResult;

interface BtreeNode<T>
extends Cursorable<T>,
SplitableIterable<T> {
    public static final int MIN_CHILDREN = 9;
    public static final int MAX_CHILDREN = 18;

    public int childCount();

    public int valueCount();

    public T get(int var1);

    @Nonnull
    public BtreeNode<T> assign(int var1, T var2);

    @Nonnull
    public BtreeInsertResult<T> insertAt(int var1, T var2);

    @Nonnull
    public BtreeInsertResult<T> append(T var1);

    @Nonnull
    public BtreeInsertResult<T> insertNode(int var1, boolean var2, @Nonnull BtreeNode<T> var3);

    @Nonnull
    public BtreeNode<T> delete(int var1);

    @Nonnull
    public BtreeNode<T> mergeChildren(BtreeNode<T> var1);

    @Nonnull
    public Tuple2<BtreeNode<T>, BtreeNode<T>> distributeChildren(BtreeNode<T> var1);

    @Nonnull
    default public BtreeNode<T> compress() {
        return this;
    }

    public boolean containsIndex(int var1);

    public int depth();

    public void checkInvariants(boolean var1);

    @Nonnull
    public Iterator<BtreeNode<T>> childIterator();
}

